/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.aspects.remoting.interceptors.marshall;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.interceptors.invoker.RemotingInterceptorFactory;
import org.jboss.remoting.marshal.Marshaller;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class MarshallInterceptor implements Interceptor
{
   private Marshaller marshaller;

   public MarshallInterceptor(Marshaller marshaller)
   {
      this.marshaller = marshaller;
   }

   public String getName()
   {
      return "MarshallInterceptor";
   }

   /**
    * By default, this will only add the marshaller to be used to the invocation meta data,
    * which will later be used by the transport.
    *
    * @param invocation
    * @return
    * @throws Throwable
    */
   public Object invoke(Invocation invocation) throws Throwable
   {
      // need to add marshaller to invocation so can be found by transport later on
      invocation.getMetaData().addMetaData(RemotingInterceptorFactory.REMOTING,
            RemotingInterceptorFactory.MARSHALLER, marshaller, PayloadKey.TRANSIENT);

      return invocation.invokeNext();
   }
}