package org.jboss.remoting.security.domain;

import org.jboss.remoting.security.ServerSocketFactoryMBean;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public interface DomainServerSocketFactoryServiceMBean extends ServerSocketFactoryMBean
{
   void setSecurityDomain(String securityDomain);

   String getSecurityDomain();

   /**
    * start the service, create is already called
    */
   void start() throws Exception;

   /**
    * create the service, do expensive operations etc
    */
   void create() throws Exception;

   /**
    * stop the service
    */
   void stop();

   /**
    * destroy the service, tear down
    */
   void destroy();
}
