/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.jvm;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnectionFactory;
import org.jboss.mq.SpyXAConnectionFactory;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.jvm.JVMServerIL;
import org.jboss.mq.il.jvm.JVMServerILServiceMBean;
import org.jboss.naming.NonSerializableFactory;

public class JVMServerILService
extends ServerILJMXService
implements JVMServerILServiceMBean {
    public String getName() {
        return "JBossMQ-JVMServerIL";
    }

    public ServerIL getServerIL() {
        return new JVMServerIL(this.getJMSServer());
    }

    public Properties getClientConnectionProperties() {
        Properties rc = super.getClientConnectionProperties();
        rc.setProperty("ClientILService", "org.jboss.mq.il.jvm.JVMClientILService");
        rc.setProperty("ServerILFactory", "org.jboss.mq.il.jvm.JVMServerILFactory");
        return rc;
    }

    public void startService() throws Exception {
        super.startService();
        this.bindJNDIReferences();
    }

    public void stopService() {
        try {
            this.unbindJNDIReferences();
        }
        catch (Exception e) {
            this.log.error((Object)"Problem stopping JVMServerILService", (Throwable)e);
        }
    }

    public void bindJNDIReferences() throws NamingException {
        GenericConnectionFactory gcf = new GenericConnectionFactory(this.getServerIL(), this.getClientConnectionProperties());
        SpyConnectionFactory scf = new SpyConnectionFactory(gcf);
        SpyXAConnectionFactory sxacf = new SpyXAConnectionFactory(gcf);
        InitialContext ctx = this.getInitialContext();
        NonSerializableFactory.rebind((Context)ctx, (String)this.getConnectionFactoryJNDIRef(), (Object)scf);
        NonSerializableFactory.rebind((Context)ctx, (String)this.getXAConnectionFactoryJNDIRef(), (Object)sxacf);
    }
}

