/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.kernel;

import java.util.Hashtable;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSTopic;
import org.jboss.util.naming.Util;

public class Topic
extends org.jboss.mq.server.jmx.Topic {
    protected JMSDestinationManager destinationManagerPojo;
    protected Hashtable initialContextProperties;

    public void setDestinationName(String name) {
        this.destinationName = name;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    protected void setupSecurityManager() throws InstanceNotFoundException, MBeanException, ReflectionException {
    }

    protected void teardownSecurityManager() throws InstanceNotFoundException, MBeanException, ReflectionException {
    }

    protected InitialContext getInitialContext() throws NamingException {
        InitialContext ctx1 = null;
        ctx1 = this.initialContextProperties != null ? new InitialContext(this.initialContextProperties) : new InitialContext();
        InitialContext ctx = ctx1;
        return ctx;
    }

    public void create() throws Exception {
        if (this.parameters.receiversImpl == null) {
            this.parameters.receiversImpl = this.destinationManagerPojo.getParameters().receiversImpl;
        }
        if (this.parameters.recoveryRetries == 0) {
            this.parameters.recoveryRetries = this.destinationManagerPojo.getParameters().recoveryRetries;
        }
    }

    public void start() throws Exception {
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new IllegalStateException("TopicName was not set");
        }
        this.spyDest = new SpyTopic(this.destinationName);
        this.destination = new JMSTopic(this.spyDest, null, this.destinationManagerPojo, this.parameters);
        this.destinationManagerPojo.addDestination(this.destination);
        if (this.jndiName == null) {
            this.setJNDIName("topic/" + this.destinationName);
        } else {
            this.setJNDIName(this.jndiName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            if (this.jndiBound) {
                InitialContext ctx = this.getInitialContext();
                try {
                    this.log.info((Object)("Unbinding JNDI name: " + this.jndiName));
                    Util.unbind((Context)ctx, (String)this.jndiName);
                }
                finally {
                    ctx.close();
                }
                this.jndiName = null;
                this.jndiBound = false;
            }
            if (this.destinationManagerPojo != null) {
                this.destinationManagerPojo.closeDestination(this.spyDest);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
    }

    public Hashtable getInitialContextProperties() {
        return this.initialContextProperties;
    }

    public void setInitialContextProperties(Hashtable initialContextProperties) {
        this.initialContextProperties = initialContextProperties;
    }

    public JMSDestinationManager getDestinationManagerPojo() {
        return this.destinationManagerPojo;
    }

    public void setDestinationManagerPojo(JMSDestinationManager destinationManagerPojo) {
        this.destinationManagerPojo = destinationManagerPojo;
    }
}

