/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.remote;

import java.io.IOException;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.security.auth.Subject;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public interface JMXConnector
{
   public static final String CREDENTIALS = "jmx.remote.credentials";

   public void connect() throws IOException;

   public void connect(Map env) throws IOException;

   public MBeanServerConnection getMBeanServerConnection() throws IOException;

   public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException;

   public void close() throws IOException;

   public String getConnectionId() throws IOException;

   public void addConnectionNotificationListener(NotificationListener listener,
                                                 NotificationFilter filter,
                                                 Object handback);

   public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException;

   public void removeConnectionNotificationListener(NotificationListener l,
                                                    NotificationFilter f,
                                                    Object handback)
         throws ListenerNotFoundException;
}