/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package javax.management.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public abstract class JMXConnectorServer extends NotificationBroadcasterSupport implements JMXConnectorServerMBean, MBeanRegistration
{
   private MBeanServer mbeanServer = null;
   private List connectionIds = new ArrayList();

   private static final Object lock = new Object();
   private static long sequenceNumber = 0;

   public static final String AUTHENTICATOR = "jmx.remote.authenticator";

   public JMXConnectorServer()
   {
      //TODO: -TME -Implement
   }

   public JMXConnectorServer(MBeanServer mbeanServer)
   {
      this.mbeanServer = mbeanServer;
   }

   public MBeanServer getMBeanServer()
   {
      return mbeanServer;
   }

   public void setMBeanServerForwarder(MBeanServerForwarder mbsf)
   {
      //TODO: -TME -Implement
   }

   public String[] getConnectionIds()
   {
      return null; //TODO: -TME -Implement
   }

   public JMXServiceURL getAddress()
   {
      return null;  //TODO: -TME -Implement
   }

   public Map getAttributes()
   {
      return null; //TODO: -TME -Implement
   }

   public JMXConnector toJMXConnector(Map env) throws IOException
   {
      return null; //TODO: -TME -Implement
   }

   public MBeanNotificationInfo[] getNotificationInfo()
   {
      return null; //TODO: -TME -Implement
   }

   protected void connectionOpened(String connectionId, String message, Object userData)
   {
      if(connectionId == null)
      {
         // per spec
         throw new NullPointerException("Connection id is null.");
      }

      synchronized(connectionIds)
      {
         connectionIds.add(connectionId);
      }

      JMXConnectionNotification notification = new JMXConnectionNotification(JMXConnectionNotification.OPENED,
                                                                             this, connectionId,
                                                                             getNextSequenceNumber(), message, userData);
      sendNotification(notification);

   }

   private static long getNextSequenceNumber()
   {
      synchronized(lock)
      {
         return sequenceNumber++;
      }
   }

   protected void connectionClosed(String connectionId, String message, Object userData)
   {
      //TODO: -TME -Implement
   }

   protected void connectionFailed(String connectionId, String message, Object userData)
   {
      //TODO: -TME -Implement
   }

   public ObjectName preRegister(MBeanServer mbs, ObjectName name)
   {
      if(mbeanServer == null)
      {
         this.mbeanServer = mbs;
      }
      return name;
   }

   public void postRegister(Boolean registrationDone)
   {
   }

   public void preDeregister() throws Exception
   {
   }

   public void postDeregister()
   {
   }
}