/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package javax.management.remote;

import java.io.IOException;
import java.util.Map;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public interface JMXConnectorServerMBean
{
   public void start() throws IOException, IllegalStateException;

   public void stop() throws IOException;

   public boolean isActive();

   public void setMBeanServerForwarder(MBeanServerForwarder forwarder) throws IllegalArgumentException;

   public String[] getConnectionIds();

   public JMXServiceURL getAddress();

   public Map getAttributes();

   public JMXConnector toJMXConnector(Map environment) throws IOException, UnsupportedOperationException, IllegalStateException;
}