/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.management.remote;

import java.security.Principal;
import java.io.Serializable;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class JMXPrincipal implements Principal, Serializable
{
   private static final long serialVersionUID = -4184480100214577411l;

   private String name = null;

   public JMXPrincipal(String name)
   {
      if(name == null)
      {
         throw new RuntimeException("Can not create JMXPrincipal without valid name as parameter.");
      }
      this.name = name;
   }

   public String getName()
   {
      return name;
   }

   public String toString()
   {
      return "JMXPrincipal - name: " + name;
   }

   public boolean equals(Object o)
   {
      if(o != null && o instanceof JMXPrincipal)
      {
         JMXPrincipal p = (JMXPrincipal)o;
         return name.equals(p.getName());
      }
      else
      {
         return false;
      }
   }

   public int hashCode()
   {
      return name.hashCode();
   }

}