/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package javax.management.remote;

import java.io.IOException;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class JMXProviderException extends IOException
{
   private static final long serialVersionUID = -3166703627550447198l;

   private Throwable cause = null;

   public JMXProviderException()
   {
      super();
   }

   public JMXProviderException(String message)
   {
      super(message);
   }

   public JMXProviderException(String message, Throwable cause)
   {
      super(message);
      this.cause = cause;
   }

   public Throwable getCause()
   {
      return cause;
   }
}
