/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package javax.management.remote;

import java.io.Serializable;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class NotificationResult implements Serializable
{
   private static final long serialVersionUID = 1191800228721395279l;

   private long earliestSequenceNumber;
   private long nextSequenceNumber;
   private TargetedNotification[] targetedNotifications;

   public NotificationResult(long earliestSequenceNumber,
                             long nextSequenceNumber,
                             TargetedNotification[] targetedNotifications)
   {
      this.earliestSequenceNumber = earliestSequenceNumber;
      this.nextSequenceNumber = nextSequenceNumber;
      this.targetedNotifications = targetedNotifications;
   }

   public long getEarliestSequenceNumber()
   {
      return earliestSequenceNumber;
   }

   public long getNextSequenceNumber()
   {
      return nextSequenceNumber;
   }

   public TargetedNotification[] getTargetedNotifications()
   {
      return targetedNotifications;
   }

   public String toString()
   {
      return "NotificationResult - earliest sequence number: " + earliestSequenceNumber +
             ", next sequence number: " + nextSequenceNumber + ", number of targeted notifications: " +
             (targetedNotifications != null ? targetedNotifications.length : 0);
   }


}