/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package javax.management.remote;

import java.io.Serializable;
import javax.management.Notification;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class TargetedNotification implements Serializable
{
   private static final long serialVersionUID = 7676132089779300926l;

   private Notification notif;
   private Integer id;

   public TargetedNotification(Notification notification, Integer listenerID)
   {
      this.notif = notification;
      this.id = listenerID;
   }

   public Notification getNotification()
   {
      return notif;
   }

   public Integer getListenerID()
   {
      return id;
   }

   public String toString()
   {
      return "TargetedNotification - listener id: " + id + ", notification: " + notif;
   }
}