/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import javax.security.auth.Subject;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class RMIJRMPServerImpl extends RMIServerImpl
{
   private final int port;
   private final RMIClientSocketFactory clientSocketFactory;
   private final RMIServerSocketFactory serverSocketFactory;
   private final Map environment;

   public RMIJRMPServerImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Map env)
         throws IOException
   {
      super(env);
      this.port = port;
      this.clientSocketFactory = csf;
      this.serverSocketFactory = ssf;
      this.environment = env;
   }

   protected void export() throws IOException
   {
      UnicastRemoteObject.exportObject(this, port, clientSocketFactory, serverSocketFactory);
   }

   protected String getProtocol()
   {
      return "rmi";
   }

   public Remote toStub() throws IOException
   {
      return RemoteObject.toStub(this);
   }

   protected RMIConnection makeClient(String connectionId, Subject subject) throws IOException
   {
      RMIConnection client = new RMIConnectionImpl(this, connectionId, getDefaultClassLoader(), subject, environment);
      UnicastRemoteObject.exportObject(client, port, clientSocketFactory, serverSocketFactory);
      return client;
   }

   protected void closeClient(RMIConnection client) throws IOException
   {
      UnicastRemoteObject.unexportObject(client, true);
   }

   protected void closeServer() throws IOException
   {
      UnicastRemoteObject.unexportObject(this, true);
   }


}