package org.jboss.mx.remoting;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

/**
 * JMXUtil is a set of utility functions for dealing with JMX servers and
 * MBeans
 *
 * @author <a href="jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 30251 $
 */
public class JMXUtil
{
   private static ObjectName mbeanserver;

   /**
    * return the local MbeanServer by using the system property <tt>jboss.remoting.jmxid</tt>
    * which is set by the NetworkRegistry MBean when registered in the mbean server
    *
    * @return
    */
   public static MBeanServer getMBeanServer()
   {
      ArrayList list = MBeanServerFactory.findMBeanServer(System.getProperty("jboss.remoting.jmxid"));
      if(list.isEmpty())
      {
         return null;
      }
      return (MBeanServer) list.iterator().next();
   }

   /**
    * get the ObjectName of the MBeanServer
    *
    * @return object name of the mbean server delegate
    * @throws Exception
    */
   public static final ObjectName getMBeanServerObjectName()
         throws Exception
   {
      if(mbeanserver == null)
      {
         mbeanserver = new ObjectName("JMImplementation:type=MBeanServerDelegate");
      }
      return mbeanserver;
   }

   /**
    * get the MBeanServerId attribute from the server
    *
    * @param server
    * @return mbean server id
    * @throws Exception
    */
   public static final String getServerId(MBeanServer server)
         throws Exception
   {
      if(server == null)
      {
         throw new NullPointerException("MBeanServer is null");
      }
      if(mbeanserver == null)
      {
         mbeanserver = new ObjectName("JMImplementation:type=MBeanServerDelegate");
      }
      return (String) server.getAttribute(mbeanserver, "MBeanServerId");
   }

}
