/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.mx.remoting;

import java.io.Serializable;
import javax.management.Notification;

/**
 * NotificationEntry represents a Notification passed back to the client from a remote
 * server so that the client can properly coorelate the Notification object with a specific
 * client-side listener object, based on the handback, which was passed to the server by the
 * client as a specific, unique key.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 30392 $
 */
public class NotificationEntry implements Serializable
{
   static final long serialVersionUID = -8038783215990131189L;
   
   private final Notification notification;
   private final Object handback;

   public NotificationEntry(Notification n, Object h)
   {
      this.notification = n;
      this.handback = h;
   }

   /**
    * return the original Notification object
    *
    * @return
    */
   public Notification getNotification()
   {
      return notification;
   }

   /**
    * return the client Handback Object, which is used to find the
    * appropriate client-side Listener to re-dispatch the notification to
    *
    * @return
    */
   public Object getHandBack()
   {
      return handback;
   }

   public String toString()
   {
      return "NotificationEntry [notification:" + notification + ",handback:" + handback + "]";
   }
}
