/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.mx.remoting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * NotificationQueue is an object that holds one or more NotificationEntry objects. This
 * object is created and passed from the server to the client during invocation so that the
 * client and re-deliver Notifications to client-side NotificationListeners.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 30392 $
 */
public class NotificationQueue implements Serializable
{
   static final long serialVersionUID = -1185639057427341662L;

   private final String sessionId;
   private final List notifications = new ArrayList();

   /**
    * create an empty queue
    *
    * @param sessionId
    */
   public NotificationQueue(String sessionId)
   {
      this.sessionId = sessionId;
   }

   public String toString()
   {
      return "NotificationQueue [sessionId:" + sessionId + ",notifications:" + notifications + "]";
   }

   /**
    * clear the queue
    */
   public void clear()
   {
      notifications.clear();
   }

   /**
    * add an entry to the queue
    *
    * @param notification
    */
   void add(NotificationEntry notification)
   {
      synchronized(notifications)
      {
         notifications.add(notification);
      }
   }

   /**
    * return the session ID associated with the queue
    *
    * @return
    */
   public String getSessionID()
   {
      return sessionId;
   }

   /**
    * return true if there are no entries, false if there are 1..n entries
    *
    * @return
    */
   public boolean isEmpty()
   {
      synchronized(notifications)
      {
         return notifications.isEmpty();
      }
   }

   /**
    * return an Iterator of NotificationEntry objects
    *
    * @return
    */
   public Iterator iterator()
   {
      synchronized(notifications)
      {
         return notifications.iterator();
      }
   }
}
