package org.jboss.mx.remoting.event;

import javax.management.Notification;
import javax.management.NotificationFilter;

/**
 * Composite-pattern based filter
 *
 * @author Jeff Haynie
 * @version $Revision: 30251 $
 */
public class CompositeEventFilter implements NotificationFilter
{
   static final long serialVersionUID = -4670317046721324670L;
   public static final int AND = 0;
   public static final int OR = 1;

   protected int operator = AND;
   protected NotificationFilter filters[];

   /**
    * create a filter composite of filters using the specific operator
    */
   public CompositeEventFilter(NotificationFilter filters[], int operator)
   {
      this.filters = filters;
      this.operator = operator;
   }

   /**
    * create a filter composite of filters using the AND operator
    */
   public CompositeEventFilter(NotificationFilter filters[])
   {
      this(filters, AND);
   }

   public boolean isNotificationEnabled(Notification event)
   {
      Class cl = event.getClass();
      for(int c = 0; c < filters.length; c++)
      {
         if(operator == AND)
         {
            if(filters[c] != null && filters[c].isNotificationEnabled(event) == false)
            {
               return false;
            }
         }
         else
         {
            if(filters[c] != null && filters[c].isNotificationEnabled(event))
            {
               return true;
            }
         }
      }
      return (operator == AND ? true : false);
   }
}

