/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.mx.remoting.provider.rmi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class ClientProvider implements JMXConnectorProvider
{
   public static final String PROTOCOL = "rmi";

   public ClientProvider()
   {

   }

   public JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map environment)
         throws IOException
   {
      if(serviceURL != null && serviceURL.getProtocol() != null && serviceURL.getProtocol().equalsIgnoreCase(PROTOCOL))
      {
         return new RMIConnector(serviceURL, environment);
      }
      else
      {
         throw new MalformedURLException("JMXServiceURL provided is invalid for this provider.  " +
                                         "Protocol must be " + PROTOCOL + ".  JMXServiceURL provided is " +
                                         serviceURL);
      }
   }
}