/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.mx.remoting.provider.rmi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerProvider;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class ServerProvider implements JMXConnectorServerProvider
{
   public static final String PROTOCOL = "rmi";

   public ServerProvider()
   {
   }

   public JMXConnectorServer newJMXConnectorServer(JMXServiceURL serviceURL, Map environment, MBeanServer server)
         throws IOException
   {
      if(serviceURL != null && serviceURL.getProtocol() != null && serviceURL.getProtocol().equalsIgnoreCase(PROTOCOL))
      {
         return new RMIConnectorServer(serviceURL, environment, server);
      }
      else
      {
         throw new MalformedURLException("JMXServiceURL provided is invalid for this provider.  " +
                                         "Protocol must be " + PROTOCOL + ".  JMXServiceURL provided is " +
                                         serviceURL);
      }
   }

}