package org.jboss.mx.remoting.rmi;

import java.io.IOException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;

/**
 * Handles the firing of notifications related to the connection
 * status of the connector.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class ConnectionNotifier extends NotificationBroadcasterSupport
{
   private JMXConnector connector;

   private static SynchronizedLong sequenceNumber = new SynchronizedLong(0);

   public ConnectionNotifier(JMXConnector connector)
   {
      this.connector = connector;
   }

   public void fireConnectedNotification()
   {
      JMXConnectionNotification notification = new JMXConnectionNotification(JMXConnectionNotification.OPENED,
                                                                             connector,
                                                                             getConnectionId(),
                                                                             sequenceNumber.increment(),
                                                                             "JMXConnector connected",
                                                                             null);
   sendNotification(notification);
   }

   private String getConnectionId()
   {
      String id = null;
      try
      {
         id = connector.getConnectionId();
      }
      catch(IOException e)
      {
      }
      return id;
   }

   public void fireClosedNotification()
   {
      JMXConnectionNotification notification = new JMXConnectionNotification(JMXConnectionNotification.CLOSED,
                                                                             connector,
                                                                             getConnectionId(),
                                                                             sequenceNumber.increment(),
                                                                             "JMXConnector closed",
                                                                             null);
      sendNotification(notification);
   }
}
