/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.mx.remoting.tracker;

import java.io.Serializable;
import javax.management.Notification;
import org.jboss.mx.remoting.MBeanLocator;

/**
 * MBeanTrackerAction
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 30251 $
 */
public interface MBeanTrackerAction extends Serializable
{
   /**
    * called when an MBean is registered with the MBeanServer
    *
    * @param locator
    */
   public void mbeanRegistered(MBeanLocator locator);

   /**
    * called when an MBean is unregistered with the MBeanServer
    *
    * @param locator
    */
   public void mbeanUnregistered(MBeanLocator locator);

   /**
    * called when a mbean notification is fired
    *
    * @param locator
    * @param notification
    * @param handback
    */
   public void mbeanNotification(MBeanLocator locator, Notification notification, Object handback);

   /**
    * called when the mbean state changes.  Note: this method will only be called on MBeans that have a
    * <tt>State</tt> attribute and where state change attribute notifications are fired
    *
    * @param locator
    * @param oldState
    * @param newState
    */
   public void mbeanStateChanged(MBeanLocator locator, int oldState, int newState);
}
