/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.compliance.core.notification;

import javax.management.Notification;
import javax.management.NotificationListener;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class Listener implements NotificationListener
{
   private int expectedCount;
   private int count;

   public Listener(int expectedCount)
   {
      this.expectedCount = expectedCount;
   }

   public int getCount()
   {
      return count;
   }

   public void handleNotification(Notification event, Object handback)
   {
      System.out.println("handleNotification, event: " + event + ", count=" + count);
      count++;
      synchronized(this)
      {
         if(count == expectedCount)
         {
            notifyAll();
         }
      }
   }
}