/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.compliance.core.notification.connection;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

import junit.framework.TestCase;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class ConnectionNotificationTest extends TestCase implements NotificationListener
{
   private JMXConnectorServer connectorServer;
   private List notificationList = new ArrayList();

   public void setUp() throws Exception
   {
      MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();

      int registryPort = Registry.REGISTRY_PORT;
      Registry rmiRegistry = LocateRegistry.createRegistry(registryPort);

      String jndiPath = "/jmxconnector";
      JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://localhost/jndi/rmi://localhost:" + registryPort + jndiPath);

      // create new connector server and start it
      connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbeanServer);
      connectorServer.start();

      System.out.println("Connector server started.");
   }

   public void tearDown() throws Exception
   {
      connectorServer.stop();
   }

   public void testConnectionNotifications() throws Exception
   {
      JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1099/jmxconnector");

      JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
      connector.addConnectionNotificationListener(this, null, null);
      connector.connect();
      connector.close();

      assertEquals("Should have received two notifications (one for connect and one for close).", 2, notificationList.size());
   }

   public void handleNotification(Notification notification, Object o)
   {
      notificationList.add(notification);
   }
}