/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package test.compliance.core.serviceurl;

import java.io.IOException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import junit.framework.TestCase;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class JMXConnectorFactoryTest extends TestCase
{
   private final String protocol = "rmi";


   public JMXConnectorFactoryTest(String name)
   {
      super(name);
   }


   public void testConnect()
   {
      String serviceURL = "service:jmx:" + protocol + "://localhost:5900";
      try
      {
         JMXServiceURL jmxServiceURL = new JMXServiceURL(serviceURL);
         JMXConnector connector = JMXConnectorFactory.connect(jmxServiceURL);
         assertNotNull(connector);
      }
      catch(IOException e)
      {
         assertTrue(e.getMessage(), false);
      }
   }

   //TODO: -TME Need to add more complicated unit tests.  The only one now just checks for creating connector.
}