/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.sample.simple;

import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.NotificationListener;
import javax.management.Notification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class Client
{
   public static void main(String[] args) throws Exception
   {
      // no host or port, since will be getting rmi stub
      JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1099/jmxconnector");

      JMXConnector connector = JMXConnectorFactory.connect(url);

      MBeanServerConnection connection = connector.getMBeanServerConnection();

      ObjectName delegateName = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
      Object proxy = MBeanServerInvocationHandler.newProxyInstance(connection, delegateName, MBeanServerDelegateMBean.class, true);
      MBeanServerDelegateMBean delegate = (MBeanServerDelegateMBean) proxy;

      System.out.println("MBeanServer vendor is " + delegate.getImplementationVendor());
      System.out.println("MBeanServer version is " + delegate.getImplementationVersion());
      System.out.println("MBeanServer specification name is " + delegate.getSpecificationName());
      System.out.println("MBeanServer specification vendor is " + delegate.getSpecificationVendor());
      System.out.println("MBeanServer specification version is " + delegate.getSpecificationVersion());
      System.out.println("MBeanServer MBeanCount is " + connection.getMBeanCount());

      ObjectName objName = new ObjectName("test:name=sample");
      connection.createMBean(Sample.class.getName(), objName);
      Object ret = connection.invoke(objName, "doSomething", new Object[] {"foo"}, new String[] {String.class.getName()});
      System.out.println("Return to doSomething() is " + ret);

      NotificationListener listener = new Listener();
      connection.addNotificationListener(objName,listener, null, null);

      ret = connection.invoke(objName, "doSomething", new Object[] {"bar"}, new String[] {String.class.getName()});
      System.out.println("Return to doSomething() is " + ret);

      // give time for notification to come in
      Thread.currentThread().sleep(5000);

      connection.removeNotificationListener(objName, listener);

      System.out.println("Removed notification listener.");

   }


   public static class Listener implements NotificationListener
   {

      /**
       * Callback method from the broadcaster MBean this listener implementation
       * is registered to.
       *
       * @param notification the notification object
       * @param handback     the handback object given to the broadcaster
       *                     upon listener registration
       */
      public void handleNotification(Notification notification, Object handback)
      {
         System.out.println("Got notification: " + notification);
      }
   }
}