/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.sample.simple;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class Server
{
   public static void main(String[] args) throws Exception
   {
      MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();

      int registryPort = Registry.REGISTRY_PORT;
      Registry rmiRegistry = LocateRegistry.createRegistry(registryPort);

      String jndiPath = "/jmxconnector";
      JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://localhost/jndi/rmi://localhost:" + registryPort + jndiPath);

      // create new connector server and start it
      JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbeanServer);
      connectorServer.start();

      System.out.println("Connector server started.");

      //UnicastRemoteObject.unexportObject(rmiRegistry, true);
   }
}