/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTaskDCL;
import org.jboss.mx.loading.DomainClassLoaderUCLImpl;
import org.jboss.mx.loading.UnifiedLoaderRepositoryDCL;

public class LoadMgrDCL {
    private static Logger log = Logger.getLogger(LoadMgrDCL.class);
    private static Object registrationLock = new Object();
    private static HashMap loadClassThreads = new HashMap();
    private static Map loadTasksByThread = Collections.synchronizedMap(new WeakHashMap());
    private static SecurityManager sm = System.getSecurityManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLoaderThread(DomainClassLoader ucl, Thread t) {
        Object object = registrationLock;
        synchronized (object) {
            Thread prevThread = loadClassThreads.put(ucl, t);
            if (log.isTraceEnabled()) {
                log.trace((Object)("registerLoaderThread, ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread));
            }
            Map map = loadTasksByThread;
            synchronized (map) {
                List taskList = (List)loadTasksByThread.get(t);
                if (taskList == null) {
                    taskList = Collections.synchronizedList(new LinkedList());
                    loadTasksByThread.put(t, taskList);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"created new task list");
                    }
                }
            }
            registrationLock.notifyAll();
        }
    }

    public static boolean beginLoadTask(ClassLoadingTaskDCL task, UnifiedLoaderRepositoryDCL repository) throws ClassNotFoundException {
        String msg;
        Class cls;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Begin beginLoadTask, task=" + task));
        }
        if ((cls = repository.loadClassFromCache(task.classname)) != null) {
            task.loadedClass = cls;
            task.state = 4;
            if (trace) {
                log.trace((Object)("End beginLoadTask, loadClassFromCache, classname: " + task.classname));
            }
            return true;
        }
        Set pkgSet = repository.getPackageClassLoaders(task.classname);
        if (pkgSet == null || pkgSet.size() == 0) {
            if (task.stopOrder == Integer.MAX_VALUE) {
                try {
                    cls = repository.loadClassFromClassLoader(task.classname, false, (DomainClassLoader)task.requestingClassLoader);
                }
                catch (LinkageError e) {
                    if (trace) {
                        log.trace((Object)("End beginLoadTask, LinkageError for task: " + task), (Throwable)e);
                    }
                    throw e;
                }
                if (cls != null) {
                    task.loadedClass = cls;
                    task.state = 4;
                    if (trace) {
                        log.trace((Object)"End beginLoadTask, loadClassFromClassLoader");
                    }
                    return true;
                }
            }
            if (trace) {
                log.trace((Object)"End beginLoadTask, ClassNotFoundException");
            }
            String msg2 = "No ClassLoaders found for: " + task.classname;
            throw new ClassNotFoundException(msg2);
        }
        Iterator iter = pkgSet.iterator();
        DomainClassLoaderUCLImpl theUCL = null;
        int order = Integer.MAX_VALUE;
        while (iter.hasNext()) {
            int uclOrder;
            DomainClassLoaderUCLImpl ucl;
            Object next = iter.next();
            if (next instanceof DomainClassLoaderUCLImpl) {
                ucl = (DomainClassLoaderUCLImpl)next;
                uclOrder = 0;
            } else {
                PkgClassLoader pkgUcl = (PkgClassLoader)next;
                ucl = pkgUcl.ucl;
                uclOrder = pkgUcl.order;
            }
            if (task.stopOrder != Integer.MAX_VALUE && task.stopOrder <= uclOrder) break;
            String classRsrcName = task.classname.replace('.', '/') + ".class";
            URL url = null;
            if (sm != null) {
                ResourceAction action = new ResourceAction((DomainClassLoader)ucl, classRsrcName);
                url = (URL)AccessController.doPrivileged(action);
            } else {
                url = ucl.loadResourceLocally(classRsrcName);
            }
            if (url == null || uclOrder >= order) continue;
            if (trace && theUCL != null) {
                log.trace((Object)("Replacing UCL: " + theUCL + " with UCL:" + ucl));
            }
            theUCL = ucl;
            order = uclOrder;
        }
        if (theUCL == null && task.stopOrder == Integer.MAX_VALUE) {
            try {
                cls = repository.loadClassFromClassLoader(task.classname, false, (DomainClassLoader)task.requestingClassLoader);
            }
            catch (LinkageError e) {
                if (trace) {
                    log.trace((Object)("End beginLoadTask, LinkageError for task: " + task), (Throwable)e);
                }
                throw e;
            }
            if (cls != null) {
                task.loadedClass = cls;
                task.state = 4;
                if (trace) {
                    log.trace((Object)"End beginLoadTask, loadClassFromClassLoader");
                }
                return true;
            }
            if (trace) {
                log.trace((Object)"End beginLoadTask, ClassNotFoundException");
            }
            msg = "No ClassLoaders found for: " + task.classname;
            throw new ClassNotFoundException(msg);
        }
        if (theUCL == null) {
            if (trace) {
                log.trace((Object)"End beginLoadTask, ClassNotFoundException");
            }
            msg = "No ClassLoaders found for: " + task.classname;
            throw new ClassNotFoundException(msg);
        }
        LoadMgrDCL.scheduleTask(task, theUCL, order, false, trace);
        task.state = 1;
        if (trace) {
            log.trace((Object)("End beginLoadTask, task=" + task));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextTask(Thread t, ClassLoadingTaskDCL task, UnifiedLoaderRepositoryDCL repository) throws InterruptedException {
        ClassLoadingTaskDCL loadTask;
        ClassLoadingTaskDCL.ThreadTask threadTask;
        List taskList;
        boolean trace;
        block54: {
            trace = log.isTraceEnabled();
            List list = taskList = (List)loadTasksByThread.get(t);
            synchronized (list) {
                while (taskList.size() == 0 && task.threadTaskCount != 0) {
                    if (trace) {
                        log.trace((Object)("Begin nextTask(WAIT_ON_EVENT), task=" + task));
                    }
                    try {
                        task.state = 3;
                        taskList.wait();
                    }
                    catch (InterruptedException e) {
                        if (trace) {
                            log.trace((Object)("nextTask(WAIT_ON_EVENT), interrupted, task=" + task), (Throwable)e);
                        }
                        throw e;
                    }
                    if (!trace) continue;
                    log.trace((Object)("nextTask(WAIT_ON_EVENT), notified, task=" + task));
                }
                if (trace) {
                    log.trace((Object)("Continue nextTask(" + taskList.size() + "), task=" + task));
                }
                if (task.threadTaskCount == 0) {
                    task.state = 4;
                    log.trace((Object)("End nextTask(FINISHED), task=" + task));
                    return;
                }
            }
            threadTask = (ClassLoadingTaskDCL.ThreadTask)taskList.remove(0);
            loadTask = threadTask.getLoadTask();
            if (trace) {
                log.trace((Object)("Begin nextTask(" + taskList.size() + "), loadTask=" + loadTask));
            }
            DomainClassLoaderUCLImpl ucl3 = threadTask.ucl;
            try {
                if (threadTask.t == null) {
                    if (trace) {
                        log.trace((Object)("Rescheduling threadTask=" + threadTask));
                    }
                    LoadMgrDCL.scheduleTask(loadTask, ucl3, threadTask.order, true, trace);
                } else {
                    if (trace) {
                        log.trace((Object)("Running threadTask=" + threadTask));
                    }
                    threadTask.run();
                }
            }
            catch (Throwable e) {
                if (e instanceof ClassCircularityError) {
                    try {
                        if (trace) {
                            log.trace((Object)"Run failed with exception", e);
                        }
                        LoadMgrDCL.scheduleTask(loadTask, ucl3, Integer.MAX_VALUE, true, trace);
                    }
                    catch (ClassNotFoundException ex) {
                        loadTask.setLoadError(ex);
                        log.warn((Object)"Failed to reschedule task after CCE", (Throwable)ex);
                    }
                    if (trace) {
                        log.trace((Object)("Post CCE state, loadTask=" + loadTask));
                    }
                    break block54;
                }
                loadTask.setLoadError(e);
                if (trace) {
                    log.trace((Object)"Run failed with exception", e);
                }
            }
            finally {
                if (threadTask.releaseInNextTask) {
                    if (trace) {
                        log.trace((Object)("Releasing loadLock and ownership of UCL: " + threadTask.ucl));
                    }
                    Object object = registrationLock;
                    synchronized (object) {
                        loadClassThreads.remove(threadTask.ucl);
                    }
                    object = threadTask.ucl;
                    synchronized (object) {
                        ucl3.release();
                        ucl3.notifyAll();
                    }
                }
            }
        }
        if (loadTask.threadTaskCount == 0) {
            List loadTaskThreadTasks;
            Class loadedClass = threadTask.getLoadedClass();
            if (loadedClass != null) {
                ClassLoader loader = loadedClass.getClassLoader();
                Object wrapper = null;
                if (wrapper != null) {
                    loader = wrapper;
                }
            }
            List list = loadTaskThreadTasks = (List)loadTasksByThread.get(loadTask.requestingThread);
            synchronized (list) {
                if (trace) {
                    log.trace((Object)("Notifying task of thread completion, loadTask:" + loadTask));
                }
                loadTask.state = 4;
                loadTaskThreadTasks.notify();
            }
        }
        if (trace) {
            log.trace((Object)("End nextTask(" + taskList.size() + "), loadTask=" + loadTask));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endLoadTask(ClassLoadingTaskDCL task) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Begin endLoadTask, task=" + task));
        }
        Object object = registrationLock;
        synchronized (object) {
            loadClassThreads.remove(task.requestingClassLoader);
            registrationLock.notifyAll();
        }
        List taskList = (List)loadTasksByThread.get(task.requestingThread);
        int size = taskList != null ? taskList.size() : 0;
        List list = taskList;
        synchronized (list) {
            for (int i = 0; i < size; ++i) {
                List toTaskList;
                ClassLoadingTaskDCL.ThreadTask threadTask = (ClassLoadingTaskDCL.ThreadTask)taskList.remove(0);
                ClassLoadingTaskDCL loadTask = threadTask.getLoadTask();
                if (trace) {
                    log.trace((Object)("Reassigning task: " + threadTask + ", to: " + loadTask.requestingThread));
                }
                threadTask.t = null;
                List list2 = toTaskList = (List)loadTasksByThread.get(loadTask.requestingThread);
                synchronized (list2) {
                    toTaskList.add(0, threadTask);
                    loadTask.state = 2;
                    toTaskList.notify();
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleTask(ClassLoadingTaskDCL task, DomainClassLoaderUCLImpl ucl, int order, boolean reschedule, boolean trace) throws ClassNotFoundException {
        Thread t = null;
        boolean releaseInNextTask = false;
        ClassLoadingTaskDCL.ThreadTask subtask = null;
        List taskList = null;
        Object object = registrationLock;
        synchronized (object) {
            t = (Thread)loadClassThreads.get(ucl);
            if (t == null) {
                while (t == null && !ucl.attempt(1L)) {
                    if (trace) {
                        log.trace((Object)("Waiting for owner of UCL: " + ucl));
                    }
                    try {
                        registrationLock.wait();
                    }
                    catch (InterruptedException e) {
                        String msg = "Interrupted waiting for registration notify, classame: " + task.classname;
                        throw new ClassNotFoundException(msg);
                    }
                    t = (Thread)loadClassThreads.get(ucl);
                    if (!trace) continue;
                    log.trace((Object)("Notified that UCL owner is: " + t));
                }
                t = (Thread)loadClassThreads.get(ucl);
                if (t == null) {
                    releaseInNextTask = true;
                    t = task.requestingThread;
                    Thread prevThread = loadClassThreads.put(ucl, t);
                    if (trace) {
                        log.trace((Object)("scheduleTask, taking ownership of ucl=" + ucl + ", t=" + t + ", prevT=" + prevThread));
                    }
                }
            }
            subtask = task.newThreadTask(ucl, t, order, reschedule, releaseInNextTask);
            List list = taskList = (List)loadTasksByThread.get(t);
            synchronized (list) {
                taskList.add(subtask);
                Collections.sort(taskList, ClassLoadingTaskDCL.taskComparator);
                taskList.notify();
            }
        }
        if (trace) {
            log.trace((Object)("scheduleTask(" + taskList.size() + "), created subtask: " + subtask));
        }
    }

    private static class ResourceAction
    implements PrivilegedAction {
        DomainClassLoader ucl;
        String classRsrcName;

        ResourceAction(DomainClassLoader ucl, String classRsrcName) {
            this.ucl = ucl;
            this.classRsrcName = classRsrcName;
        }

        public Object run() {
            URL url = this.ucl.loadResourceLocally(this.classRsrcName);
            this.ucl = null;
            this.classRsrcName = null;
            return url;
        }
    }

    public static class PkgClassLoader {
        public final DomainClassLoaderUCLImpl ucl;
        public final int order;

        public PkgClassLoader(DomainClassLoaderUCLImpl ucl) {
            this(ucl, Integer.MAX_VALUE);
        }

        public PkgClassLoader(DomainClassLoaderUCLImpl ucl, int order) {
            this.ucl = ucl;
            this.order = order;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(super.toString());
            buffer.append("{ucl=").append(this.ucl);
            buffer.append(" order=").append(this.order);
            buffer.append('}');
            return buffer.toString();
        }
    }
}

