/*
 * Decompiled with CFR 0.152.
 */
package test.implementation.registry;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.mx.server.ServerConstants;
import test.implementation.registry.support.Trivial;

public class ValuesTestCase
extends TestCase
implements ServerConstants {
    public ValuesTestCase(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassLoader() throws Exception {
        String previous = System.getProperty("jbossmx.mbean.registry.class");
        if (previous == null) {
            previous = "org.jboss.mx.server.registry.BasicMBeanRegistry";
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            HashMap<String, ClassLoader> valuesMap = new HashMap<String, ClassLoader>();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            valuesMap.put("org.jboss.mx.classloader", Thread.currentThread().getContextClassLoader());
            ObjectName mbean = new ObjectName("test:test=test");
            server.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "registerMBean", new Object[]{new Trivial(), mbean, valuesMap}, new String[]{Object.class.getName(), ObjectName.class.getName(), Map.class.getName()});
            Object result = server.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "getValue", new Object[]{mbean, "org.jboss.mx.classloader"}, new String[]{ObjectName.class.getName(), String.class.getName()});
            ValuesTestCase.assertEquals((Object)cl, (Object)result);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
            System.setProperty("jbossmx.mbean.registry.class", previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValue() throws Exception {
        String previous = System.getProperty("jbossmx.mbean.registry.class");
        if (previous == null) {
            previous = "org.jboss.mx.server.registry.BasicMBeanRegistry";
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            HashMap<String, Date> valuesMap = new HashMap<String, Date>();
            Date date = new Date(System.currentTimeMillis());
            valuesMap.put("date", date);
            ObjectName mbean = new ObjectName("test:test=test");
            server.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "registerMBean", new Object[]{new Trivial(), mbean, valuesMap}, new String[]{Object.class.getName(), ObjectName.class.getName(), Map.class.getName()});
            Object result = server.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "getValue", new Object[]{mbean, "date"}, new String[]{ObjectName.class.getName(), String.class.getName()});
            ValuesTestCase.assertEquals((Object)date, (Object)result);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
            System.setProperty("jbossmx.mbean.registry.class", previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValueRegistered() throws Exception {
        String previous = System.getProperty("jbossmx.mbean.registry.class");
        if (previous == null) {
            previous = "org.jboss.mx.server.registry.BasicMBeanRegistry";
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        try {
            HashMap<String, Date> valuesMap = new HashMap<String, Date>();
            Date date = new Date(System.currentTimeMillis());
            valuesMap.put("date", date);
            ObjectName mbean = new ObjectName("test:test=test");
            server.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "registerMBean", new Object[]{new Trivial(), mbean, valuesMap}, new String[]{Object.class.getName(), ObjectName.class.getName(), Map.class.getName()});
            Object result = server.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "getValue", new Object[]{mbean, "date"}, new String[]{ObjectName.class.getName(), String.class.getName()});
            ValuesTestCase.assertEquals((Object)date, (Object)result);
            server.unregisterMBean(mbean);
            Thread.sleep(2L);
            date = new Date(System.currentTimeMillis());
            HashMap<String, Date> valueMap2 = new HashMap<String, Date>();
            valueMap2.put("date", date);
            server.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "registerMBean", new Object[]{new Trivial(), mbean, valueMap2}, new String[]{Object.class.getName(), ObjectName.class.getName(), Map.class.getName()});
            result = server.invoke(new ObjectName("JMImplementation:type=MBeanRegistry"), "getValue", new Object[]{mbean, "date"}, new String[]{ObjectName.class.getName(), String.class.getName()});
            ValuesTestCase.assertEquals((Object)date, (Object)result);
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(server);
            System.setProperty("jbossmx.mbean.registry.class", previous);
        }
    }
}

