/*
 * Decompiled with CFR 0.152.
 */
package test.implementation.modelmbean;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.modelmbean.DescriptorSupport;
import junit.framework.TestCase;
import org.jboss.mx.modelmbean.XMBean;
import org.jboss.mx.modelmbean.XMBeanConstants;
import test.implementation.modelmbean.support.Trivial;
import test.implementation.modelmbean.support.User;

public class XMBeanTEST
extends TestCase
implements XMBeanConstants {
    public XMBeanTEST(String s) {
        super(s);
    }

    public void testCreateXMBean() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        DescriptorSupport d = new DescriptorSupport();
        d.setField("xmbean.resource.reference", new User());
        d.setField("xmbean.resource.type", "file:./src/main/test/implementation/modelmbean/support/xml/UserManagementInterface.xml");
        d.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
        XMBean mmb = new XMBean((Object)d, "descriptor");
        ObjectName name = new ObjectName(":test=test");
        server.registerMBean(mmb, name);
        XMBeanTEST.assertTrue((boolean)server.isRegistered(name));
        server.setAttribute(name, new Attribute("Name", "Juha"));
        XMBeanTEST.assertTrue((boolean)server.getAttribute(name, "Name").equals("Juha"));
        server.setAttribute(name, new Attribute("Address", "StrawBerry Street"));
        XMBeanTEST.assertTrue((boolean)server.getAttribute(name, "Address").equals("StrawBerry Street"));
        XMBeanTEST.assertTrue((boolean)(server.invoke(name, "printInfo", null, null) instanceof String));
    }

    public void testCreateWithJBossXMBean10DTD() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        DescriptorSupport d = new DescriptorSupport();
        d.setField("xmbean.resource.reference", new User());
        d.setField("xmbean.resource.type", "file:./src/main/test/implementation/modelmbean/support/xml/User.xml");
        d.setField("xmbean.metadata.sax.parser", "org.apache.crimson.parser.XMLReaderImpl");
        XMBean mmb = new XMBean((Object)d, "descriptor");
        server.registerMBean(mmb, new ObjectName(":test=test"));
        XMBeanTEST.assertTrue((boolean)server.isRegistered(new ObjectName(":test=test")));
        server.setAttribute(new ObjectName(":test=test"), new Attribute("Name", "Juha"));
        XMBeanTEST.assertTrue((boolean)server.getAttribute(new ObjectName(":test=test"), "Name").equals("Juha"));
    }

    public void testCreateWithStandardInterface() throws Exception {
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        Trivial trivial = new Trivial();
        ObjectName name = new ObjectName(":foo=bar");
        XMBean mmb = new XMBean((Object)trivial, "StandardInterface");
        server.registerMBean(mmb, name);
        XMBeanTEST.assertTrue((boolean)server.isRegistered(new ObjectName(":foo=bar")));
        server.setAttribute(name, new Attribute("Something", "foobar"));
        XMBeanTEST.assertTrue((boolean)server.getAttribute(name, "Something").equals("foobar"));
        Boolean b = (Boolean)server.invoke(name, "doOperation", new Object[]{""}, new String[]{"java.lang.String"});
        XMBeanTEST.assertTrue((b == true ? 1 : 0) != 0);
    }
}

