/*
 * Decompiled with CFR 0.152.
 */
package test.stress;

import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class ConcurrencyTestCase
extends TestCase {
    static final int N = 100000;
    static final int Nadders = 2;
    static final int NDomains = 1;
    static final List names = Collections.synchronizedList(new LinkedList());
    private MBeanServer server;
    private Random rnd;
    private boolean adding;

    public ConcurrencyTestCase(String s) {
        super(s);
    }

    public void testAddRemoveQuery() throws Exception {
        int n;
        MBeanAdder[] adders = new MBeanAdder[2];
        Thread[] adderThreads = new Thread[2];
        MBeanRemover[] removers = new MBeanRemover[2];
        Thread[] removerThreads = new Thread[2];
        MBeanFinder finder = new MBeanFinder();
        this.adding = true;
        for (int n2 = 0; n2 < adders.length; ++n2) {
            int minID = n2 * 100000 / 2;
            int maxID = (n2 + 1) * 100000 / 2;
            adders[n2] = new MBeanAdder(minID, maxID);
            adderThreads[n2] = new Thread((Runnable)adders[n2], "MBeanAdder#" + n2);
            adderThreads[n2].start();
        }
        Thread t1 = new Thread((Runnable)finder, "MBeanFinder");
        t1.start();
        for (n = 0; n < adders.length; ++n) {
            removers[n] = new MBeanRemover();
            removerThreads[n] = new Thread((Runnable)removers[n], "MBeanRemover#" + n);
            removerThreads[n].start();
        }
        for (n = 0; n < adders.length; ++n) {
            adderThreads[n].join();
        }
        this.adding = false;
        t1.join();
        for (n = 0; n < adders.length; ++n) {
            removerThreads[n].join();
        }
        for (n = 0; n < adders.length; ++n) {
            ConcurrencyTestCase.assertNull((String)("There was no exception in MBeanAdder#" + n), (Object)adders[n].getException());
        }
        ConcurrencyTestCase.assertNull((String)"There was no exception in MBeanFinder", (Object)finder.getException());
        for (n = 0; n < adders.length; ++n) {
            ConcurrencyTestCase.assertNull((String)("There was no exception in MBeanRemover#" + n), (Object)removers[n].getException());
        }
    }

    protected void setUp() {
        this.server = MBeanServerFactory.createMBeanServer();
        this.rnd = new Random();
    }

    protected void tearDown() throws Exception {
        MBeanServerFactory.releaseMBeanServer(this.server);
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class Simple
    implements SimpleMBean {
        private ObjectName name;

        Simple(ObjectName name) {
            this.name = name;
        }

        public ObjectName getName() {
            return this.name;
        }
    }

    static interface SimpleMBean {
        public ObjectName getName();
    }

    class MBeanFinder
    implements Runnable {
        private Throwable ex;

        MBeanFinder() {
        }

        public void run() {
            try {
                ObjectName query = new ObjectName("jboss.test.*:type=simple,*");
                int count = 0;
                while (ConcurrencyTestCase.this.adding) {
                    Set<ObjectName> matches = ConcurrencyTestCase.this.server.queryNames(query, null);
                    if (++count % 1000 != 0) continue;
                    System.out.println(count + " queries, names.size=" + names.size() + ", matches.size=" + matches.size());
                }
            }
            catch (Throwable t) {
                this.ex = t;
                this.ex.printStackTrace();
            }
        }

        Throwable getException() {
            return this.ex;
        }
    }

    class MBeanRemover
    implements Runnable {
        private Throwable ex;

        MBeanRemover() {
        }

        public void run() {
            block4: while (true) {
                try {
                    while (ConcurrencyTestCase.this.adding) {
                        int max = names.size();
                        if (max == 0) {
                            ConcurrencyTestCase.this.sleep(10L);
                            continue;
                        }
                        int index = ConcurrencyTestCase.this.rnd.nextInt(max);
                        try {
                            ObjectName name = (ObjectName)names.remove(index);
                            ConcurrencyTestCase.this.server.unregisterMBean(name);
                            continue block4;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        }
                    }
                    break;
                }
                catch (Throwable t) {
                    this.ex = t;
                    this.ex.printStackTrace();
                    break;
                }
            }
        }

        Throwable getException() {
            return this.ex;
        }
    }

    class MBeanAdder
    implements Runnable {
        private int minID;
        private int maxID;
        private String domain;
        private Hashtable<String, String> nameProps = new Hashtable();
        private Throwable ex;

        MBeanAdder(int minID, int maxID) {
            this.minID = minID;
            this.maxID = maxID;
        }

        public void run() {
            System.out.println("MBeanAdder, min=" + this.minID + ", max=" + this.maxID + ", starting");
            this.nameProps.put("type", "simple");
            try {
                for (int n = 0; n < 100000; ++n) {
                    int id = this.minID + n % this.maxID;
                    this.domain = "jboss.test." + ConcurrencyTestCase.this.rnd.nextInt(1);
                    this.nameProps.put("id", "#" + id);
                    this.addMBean();
                }
            }
            catch (Throwable t) {
                this.ex = t;
                this.ex.printStackTrace();
            }
            System.out.println("MBeanAdder, min=" + this.minID + ", max=" + this.maxID + ", ending");
        }

        void addMBean() throws Exception {
            ObjectName name = new ObjectName(this.domain, this.nameProps);
            if (ConcurrencyTestCase.this.server.isRegistered(name)) {
                ConcurrencyTestCase.this.server.unregisterMBean(name);
            }
            Simple mbean = new Simple(name);
            ConcurrencyTestCase.this.server.registerMBean(mbean, name);
            names.add(name);
        }

        Throwable getException() {
            return this.ex;
        }
    }
}

