/*
 * Decompiled with CFR 0.152.
 */
package test.implementation.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.mx.server.ServerObjectInstance;
import test.implementation.server.support.Trivial;

public class ObjectInstanceTestCase
extends TestCase {
    public ObjectInstanceTestCase(String s) {
        super(s);
    }

    public void testDefaultDomain() {
        MBeanServer server = null;
        ObjectName unqualifiedName = null;
        ObjectName qualifiedName = null;
        ObjectInstance instance1 = null;
        ObjectInstance instance2 = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            unqualifiedName = new ObjectName(":property=1");
            qualifiedName = new ObjectName("DefaultDomain:property=1");
            instance1 = server.registerMBean(new Trivial(), qualifiedName);
            instance2 = server.getObjectInstance(unqualifiedName);
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        ObjectInstanceTestCase.assertEquals((Object)instance1.getObjectName(), qualifiedName);
        ObjectInstanceTestCase.assertEquals((Object)instance1, instance2);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testDifferentServers() {
        MBeanServer server = null;
        ObjectName name = null;
        ObjectInstance instance1 = null;
        ObjectInstance instance2 = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            name = new ObjectName(":property=1");
            instance1 = server.registerMBean(new Trivial(), name);
            MBeanServerFactory.releaseMBeanServer(server);
            server = MBeanServerFactory.createMBeanServer();
            instance2 = server.registerMBean(new Trivial(), name);
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        if (instance1.equals(instance2)) {
            ObjectInstanceTestCase.fail((String)"Instances in different servers are the same");
        }
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testEquals() {
        ObjectInstance oi = null;
        ServerObjectInstance soi = null;
        ObjectName name = null;
        String className = "org.jboss.AClass";
        try {
            name = new ObjectName(":a=a");
            oi = new ObjectInstance(name, className);
            soi = new ServerObjectInstance(name, className, "agentid");
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        ObjectInstanceTestCase.assertEquals(oi, soi);
    }

    public void testSerialization() {
        ServerObjectInstance original = null;
        Object result = null;
        ObjectName name = null;
        String className = "org.jboss.AClassName";
        try {
            name = new ObjectName(":a=a");
            original = new ServerObjectInstance(name, className, "agentid");
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(original);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = (ObjectInstance)ois.readObject();
        }
        catch (IOException ioe) {
            ObjectInstanceTestCase.fail((String)ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            ObjectInstanceTestCase.fail((String)cnfe.toString());
        }
        ObjectInstanceTestCase.assertEquals((String)"javax.management.ObjectInstance", (String)result.getClass().getName());
        ObjectInstanceTestCase.assertEquals((Object)name, (Object)((ObjectInstance)result).getObjectName());
        ObjectInstanceTestCase.assertEquals((String)className, (String)((ObjectInstance)result).getClassName());
    }
}

