/*
 * Decompiled with CFR 0.152.
 */
package test.performance.timer;

import java.util.Date;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;
import javax.management.timer.TimerNotification;
import junit.framework.TestCase;

public class TimerTortureTestCase
extends TestCase
implements NotificationListener {
    String TIMER_TYPE = "TimerType";
    String MESSAGE = "Message";
    String USER_DATA = "UserData";
    MBeanServer server;
    ObjectName timerName;
    Timer timer;
    Integer id;
    int target = 0;
    int notifications = 0;

    public TimerTortureTestCase(String s) {
        super(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTortureOne() {
        System.err.println("\nTimer iterations 2000");
        System.err.println("One notification at 1 millsecond intervals.");
        this.initTest();
        try {
            this.initTimer();
            this.startTimer();
            this.target = 2000;
            long start = this.timeOffset(0L).getTime();
            this.addNotification(1000L, 1L, 2000L);
            this.sync();
            this.sleep(1000L);
            long end = this.timeOffset(0L).getTime();
            this.stopTimer();
            System.err.println("Time (ms): " + (end - start));
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTortureTen() {
        System.err.println("\nTimer iterations 2000");
        System.err.println("Ten notifications at 1 millsecond intervals.");
        this.initTest();
        try {
            this.initTimer();
            this.startTimer();
            this.target = 20000;
            long start = this.timeOffset(0L).getTime();
            for (int i = 0; i < 10; ++i) {
                this.addNotification(1000L, 1L, 2000L);
            }
            this.sync();
            this.sleep(1000L);
            long end = this.timeOffset(0L).getTime();
            this.stopTimer();
            System.err.println("Time (ms): " + (end - start));
        }
        finally {
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    private void initTest() {
        this.notifications = 0;
        this.server = MBeanServerFactory.createMBeanServer();
    }

    private void initTimer() {
        try {
            this.timer = new Timer();
            this.timerName = new ObjectName("test:type=timer");
            this.server.registerMBean(this.timer, this.timerName);
            this.server.addNotificationListener(this.timerName, this, null, null);
        }
        catch (Exception e) {
            TimerTortureTestCase.fail((String)e.toString());
        }
    }

    private void startTimer() {
        this.timer.start();
    }

    private void stopTimer() {
        this.timer.stop();
    }

    private void addNotification(long offset, long period, long occurs) {
        this.id = this.timer.addNotification(this.TIMER_TYPE, this.MESSAGE, this.USER_DATA, this.timeOffset(offset), period, occurs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification n, Object ignored) {
        ++this.notifications;
        TimerNotification tn = (TimerNotification)n;
        if (this.timer.getNbOccurences(tn.getNotificationID()) == 1L) {
            ObjectName objectName = this.timerName;
            synchronized (objectName) {
                this.timerName.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        ObjectName objectName = this.timerName;
        synchronized (objectName) {
            try {
                this.timerName.wait(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private Date timeOffset(long offset) {
        return new Date(System.currentTimeMillis() + offset);
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

