/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.SecurityActions;
import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.bootstrap.api.as.server.JBossASServer;
import org.jboss.bootstrap.api.factory.ServerFactory;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;

public class Main {
    private URL bootURL;
    private List<URL> bootLibraries = new LinkedList<URL>();
    private List<URL> extraLibraries = new LinkedList<URL>();
    private List<URL> extraClasspath = new LinkedList<URL>();
    @Deprecated
    public static final String[] DEFAULT_BOOT_LIBRARY_LIST = new String[]{"concurrent.jar", "jboss-logging.jar", "jboss-logmanager.jar", "jboss-common-core.jar", "xercesImpl.jar", "jbossxb.jar", "jboss-bootstrap-spi.jar", "jboss-bootstrap-spi-as.jar", "jboss-bootstrap-spi-mc.jar", "jboss-bootstrap-impl-base.jar", "jboss-bootstrap-impl-as.jar", "jboss-bootstrap-impl-mc.jar", "jboss-bootstrap-api-as.jar", "jboss-bootstrap-api-mc.jar", "jboss-bootstrap-api.jar", "javassist.jar", "jboss-reflect.jar", "jboss-mdr.jar", "jboss-dependency.jar", "jboss-kernel.jar", "jboss-metatype.jar", "jboss-managed.jar", "javax.inject.jar", "jboss-classpool.jar", "jboss-classpool-scoped.jar", "jboss-vfs.jar", "jboss-classloading-spi.jar", "jboss-classloader.jar", "jboss-classloading.jar", "jboss-classloading-vfs.jar", "jboss-aop.jar", "jboss-aop-mc-int.jar", "trove.jar"};
    private Map<String, String> props = new HashMap<String, String>();
    private JBossASServer server;
    private static final String DEFAULT_AS_SERVER_IMPL_CLASS_NAME = "org.jboss.bootstrap.impl.as.server.JBossASServerImpl";
    private static final String SYS_PROP_BOOT_LOG_DIR_NAME = "jboss.boot.server.log.dir";

    public Main() {
        Properties sysProps = System.getProperties();
        for (Object propName : sysProps.keySet()) {
            String propNameString = (String)propName;
            String propValue = (String)sysProps.get(propNameString);
            this.props.put(propNameString, propValue);
        }
    }

    public JBossASServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(String[] args) throws Exception {
        int i;
        String rmiClassLoaderSpi;
        String logManagerClassName;
        String nodeName;
        String useUnorderedSequence = System.getProperty("xb.builder.useUnorderedSequence");
        if (useUnorderedSequence == null) {
            System.setProperty("xb.builder.useUnorderedSequence", "true");
        }
        System.setProperty("xb.builder.repeatableParticleHandlers", "false");
        this.processCommandLine(args);
        String hostName = System.getProperty("jboss.host.name");
        String qualifiedHostName = System.getProperty("jboss.qualified.host.name");
        if (qualifiedHostName == null) {
            qualifiedHostName = hostName;
            if (qualifiedHostName == null) {
                qualifiedHostName = System.getenv("HOSTNAME");
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = System.getenv("COMPUTERNAME");
            }
            if (qualifiedHostName == null) {
                try {
                    qualifiedHostName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    qualifiedHostName = null;
                }
            }
            if (qualifiedHostName != null && qualifiedHostName.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:")) {
                qualifiedHostName = null;
            }
            if (qualifiedHostName == null) {
                qualifiedHostName = "unknown-host.unknown-domain";
            }
            qualifiedHostName = qualifiedHostName.trim().toLowerCase();
            System.setProperty("jboss.qualified.host.name", qualifiedHostName);
        }
        if (hostName == null) {
            int idx = qualifiedHostName.indexOf(46);
            hostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
            System.setProperty("jboss.host.name", hostName);
        }
        if ((nodeName = System.getProperty("jboss.node.name")) == null) {
            nodeName = hostName;
            System.setProperty("jboss.node.name", nodeName);
        }
        if ((logManagerClassName = System.getProperty("java.util.logging.manager")) == null) {
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
            String pluginClass = System.getProperty("org.jboss.logging.Logger.pluginClass");
            if (pluginClass == null) {
                System.setProperty("org.jboss.logging.Logger.pluginClass", "org.jboss.logging.logmanager.LoggerPluginImpl");
                System.setProperty("log4j.defaultInitOverride", "true");
            }
        }
        if ((rmiClassLoaderSpi = System.getProperty("java.rmi.server.RMIClassLoaderSpi")) == null) {
            String jbossRMIClassLoader = "org.jboss.system.JBossRMIClassLoader";
            try {
                Thread.currentThread().getContextClassLoader().loadClass(jbossRMIClassLoader);
                System.setProperty("java.rmi.server.RMIClassLoaderSpi", jbossRMIClassLoader);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        String homeUrl = this.props.get("jboss.home.url");
        String homeDir = this.props.get("jboss.home.dir");
        URL jbossHome = null;
        if (homeUrl != null) {
            jbossHome = new URL(homeUrl);
        } else if (homeDir != null) {
            File homeDirFile = new File(homeDir);
            if (!homeDirFile.exists()) {
                throw new IllegalArgumentException("Specified jboss.home.dir does not point to a valid location: " + homeDirFile.toString());
            }
            jbossHome = homeDirFile.toURI().toURL();
        } else {
            URL homeUrlFromDir;
            String path = Main.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            path = URLDecoder.decode(path, "UTF-8");
            File runJar = new File(path);
            File homeFile = runJar.getParentFile().getParentFile();
            jbossHome = homeUrlFromDir = homeFile.toURI().toURL();
        }
        String libUrlFromProp = this.props.get("jboss.lib.url");
        URL libUrl = null;
        libUrl = libUrlFromProp != null ? new URL(libUrlFromProp) : new URL(jbossHome, "lib/");
        String sysPropBootLogDir = SYS_PROP_BOOT_LOG_DIR_NAME;
        String sysPropLogDir = "jboss.server.log.dir";
        String serverName = this.props.get("jboss.server.name");
        if (serverName == null || serverName.length() == 0) {
            serverName = "default";
        }
        String manualBootLogDir = this.props.get(SYS_PROP_BOOT_LOG_DIR_NAME);
        String manualLogDir = this.props.get("jboss.server.log.dir");
        if (manualBootLogDir == null && manualLogDir == null) {
            URL serverLog = new URL(jbossHome, "server/" + serverName + "/log/");
            File serverLogFile = new File(serverLog.toURI());
            String serverLogString = serverLogFile.getAbsolutePath();
            SecurityActions.setSystemProperty(SYS_PROP_BOOT_LOG_DIR_NAME, serverLogString);
        } else if (manualLogDir != null) {
            SecurityActions.setSystemProperty(SYS_PROP_BOOT_LOG_DIR_NAME, manualLogDir);
        }
        ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
        HashSet<URL> urls = new HashSet<URL>();
        if (this.bootURL != null) {
            if (this.bootURL.getProtocol().equals("file")) {
                File dir = new File(this.bootURL.getFile());
                if (dir.exists()) {
                    urls.add(dir.toURL());
                    File[] jars = dir.listFiles(new JarFilter());
                    for (int j = 0; jars != null && j < jars.length; ++j) {
                        urls.add(jars[j].getCanonicalFile().toURL());
                    }
                }
            } else {
                urls.add(this.bootURL);
            }
        }
        for (i = 0; i < this.bootLibraries.size(); ++i) {
            urls.add(this.bootLibraries.get(i));
        }
        for (i = 0; i < this.extraLibraries.size(); ++i) {
            urls.add(this.extraLibraries.get(i));
        }
        for (i = 0; i < this.extraClasspath.size(); ++i) {
            urls.add(this.extraClasspath.get(i));
        }
        File bootLibDir = new File(libUrl.toURI());
        if (!bootLibDir.exists()) {
            throw new IllegalArgumentException("Boot lib directory not found: " + bootLibDir.toString());
        }
        if (!bootLibDir.isDirectory()) {
            throw new IllegalArgumentException("Boot lib directory is not a directory: " + bootLibDir.toString());
        }
        for (String filename : DEFAULT_BOOT_LIBRARY_LIST) {
            File bootLibFile = new File(bootLibDir, filename);
            if (!bootLibFile.exists()) {
                System.out.println("WARNING: Could not find expected boot lib " + bootLibFile);
            }
            URL bootLibUrl = bootLibFile.toURI().toURL();
            urls.add(bootLibUrl);
        }
        URL[] urlArray = urls.toArray(new URL[0]);
        URLClassLoader loadingCl = new URLClassLoader(urlArray, tccl);
        this.server = (JBossASServer)JBossASServer.class.cast(ServerFactory.createServer(DEFAULT_AS_SERVER_IMPL_CLASS_NAME, loadingCl));
        Object jdk6Bug6548436Hack = this.server.getConfiguration();
        JBossASServerConfig config = (JBossASServerConfig)jdk6Bug6548436Hack;
        ((JBossASServerConfig)config.properties(this.props)).jbossHome(jbossHome);
        SecurityActions.addShutdownHook(new ShutdownHook(this.server, loadingCl));
        try {
            SecurityActions.setThreadContextClassLoader(loadingCl);
            this.server.initialize();
            this.server.start();
        }
        finally {
            SecurityActions.setThreadContextClassLoader(tccl);
        }
    }

    public void shutdown() throws Throwable {
        this.server.shutdown();
    }

    private URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private void processCommandLine(String[] args) throws Exception {
        int code;
        String programName = System.getProperty("program.name", "jboss");
        String sopts = "-:hD:d:p:n:c:Vj::B:L:C:P:b:g:u:m:H:N:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("bootdir", 1, null, 100), new LongOpt("patchdir", 1, null, 112), new LongOpt("netboot", 1, null, 110), new LongOpt("configuration", 1, null, 99), new LongOpt("version", 0, null, 86), new LongOpt("jaxp", 1, null, 106), new LongOpt("bootlib", 1, null, 66), new LongOpt("library", 1, null, 76), new LongOpt("classpath", 1, null, 67), new LongOpt("properties", 1, null, 80), new LongOpt("host", 1, null, 98), new LongOpt("partition", 1, null, 103), new LongOpt("udp", 1, null, 117), new LongOpt("mcast_port", 1, null, 109), new LongOpt("hostname", 1, null, 72), new LongOpt("nodename", 1, null, 78)};
        Getopt getopt = new Getopt(programName, args, sopts, lopts);
        block22: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    System.exit(1);
                    continue block22;
                }
                case 1: {
                    System.err.println(programName + ": unused non-option argument: " + getopt.getOptarg());
                    continue block22;
                }
                case 104: {
                    System.out.println("usage: " + programName + " [options]");
                    System.out.println();
                    System.out.println("options:");
                    System.out.println("    -h, --help                    Show this help message");
                    System.out.println("    -V, --version                 Show version information");
                    System.out.println("    --                            Stop processing options");
                    System.out.println("    -D<name>[=<value>]            Set a system property");
                    System.out.println("    -d, --bootdir=<dir>           Set the boot patch directory; Must be absolute or url");
                    System.out.println("    -p, --patchdir=<dir>          Set the patch directory; Must be absolute or url");
                    System.out.println("    -n, --netboot=<url>           Boot from net with the given url as base");
                    System.out.println("    -c, --configuration=<name>    Set the server configuration name");
                    System.out.println("    -B, --bootlib=<filename>      Add an extra library to the front bootclasspath");
                    System.out.println("    -L, --library=<filename>      Add an extra library to the loaders classpath");
                    System.out.println("    -C, --classpath=<url>         Add an extra url to the loaders classpath");
                    System.out.println("    -P, --properties=<url>        Load system properties from the given url");
                    System.out.println("    -b, --host=<host or ip>       Bind address for all JBoss services");
                    System.out.println("    -g, --partition=<name>        HA Partition name (default=DefaultDomain)");
                    System.out.println("    -m, --mcast_port=<ip>         UDP multicast port; only used by JGroups");
                    System.out.println("    -u, --udp=<ip>                UDP multicast address");
                    System.out.println("    -H, --hostname=<name>         Set the host name");
                    System.out.println("    -N, --nodename=<name>         Set the node name to use");
                    System.out.println();
                    System.exit(0);
                    continue block22;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    if (!"bind.address".equals(name)) continue block22;
                    System.setProperty("jgroups.bind_addr", value);
                    continue block22;
                }
                case 100: {
                    this.bootURL = this.makeURL(getopt.getOptarg());
                    continue block22;
                }
                case 112: {
                    URL patchURL = this.makeURL(getopt.getOptarg());
                    continue block22;
                }
                case 110: {
                    String arg = getopt.getOptarg();
                    if (!arg.endsWith("/")) {
                        arg = arg + "/";
                    }
                    this.props.put("jboss.home.url", new URL(arg).toString());
                    continue block22;
                }
                case 99: {
                    String arg = getopt.getOptarg();
                    this.props.put("jboss.server.name", arg);
                    continue block22;
                }
                case 86: {
                    Package jbossPackage = Package.getPackage("org.jboss");
                    System.out.println("JBoss " + jbossPackage.getImplementationVersion());
                    System.out.println();
                    System.out.println("Distributable under LGPL license.");
                    System.out.println("See terms of license at gnu.org.");
                    System.out.println();
                    System.exit(0);
                    continue block22;
                }
                case 106: {
                    System.err.println(programName + ": option '-j, --jaxp' no longer supported");
                    System.exit(1);
                    continue block22;
                }
                case 66: {
                    String arg = getopt.getOptarg();
                    this.bootLibraries.add(new File(arg).toURI().toURL());
                    continue block22;
                }
                case 76: {
                    String arg = getopt.getOptarg();
                    this.extraLibraries.add(new File(arg).toURI().toURL());
                    continue block22;
                }
                case 67: {
                    URL url = this.makeURL(getopt.getOptarg());
                    this.extraClasspath.add(url);
                    continue block22;
                }
                case 80: {
                    URL url = this.makeURL(getopt.getOptarg());
                    Properties props = System.getProperties();
                    props.load(url.openConnection().getInputStream());
                    continue block22;
                }
                case 98: {
                    String rmiHost;
                    String arg = getopt.getOptarg();
                    String bindAddressPropName = "jboss.bind.address";
                    this.props.put("jboss.bind.address", arg);
                    System.setProperty("jboss.bind.address", arg);
                    String bindAddress = System.getProperty("bind.address");
                    if (bindAddress == null) {
                        System.setProperty("bind.address", arg);
                    }
                    if ((bindAddress = System.getProperty("jgroups.bind_addr")) == null) {
                        System.setProperty("jgroups.bind_addr", arg);
                    }
                    if ((rmiHost = System.getProperty("java.rmi.server.hostname")) != null) continue block22;
                    System.setProperty("java.rmi.server.hostname", arg);
                    continue block22;
                }
                case 103: {
                    String arg = getopt.getOptarg();
                    String partitionNamePropName = "jboss.partition.name";
                    this.props.put("jboss.partition.name", arg);
                    System.setProperty("jboss.partition.name", arg);
                    continue block22;
                }
                case 117: {
                    String arg = getopt.getOptarg();
                    String udpGroupPropName = "jboss.partition.udpGroup";
                    this.props.put("jboss.partition.udpGroup", arg);
                    System.setProperty("jboss.partition.udpGroup", arg);
                    System.setProperty("jgroups.udp.mcast_addr", arg);
                    continue block22;
                }
                case 109: {
                    String arg = getopt.getOptarg();
                    String udpPortPropName = "jboss.jgroups.udp.mcast_port";
                    this.props.put("jboss.jgroups.udp.mcast_port", arg);
                    System.setProperty("jboss.jgroups.udp.mcast_port", arg);
                    continue block22;
                }
                case 72: {
                    String arg = getopt.getOptarg();
                    System.setProperty("jboss.qualified.host.name", arg.trim().toLowerCase());
                    continue block22;
                }
                case 78: {
                    String arg = getopt.getOptarg();
                    System.setProperty("jboss.node.name", arg.trim());
                    continue block22;
                }
            }
            throw new Error("unhandled option code: " + code);
        }
        Properties sysProps = System.getProperties();
        for (Object propName : sysProps.keySet()) {
            String propNameString = (String)propName;
            String propValue = (String)sysProps.get(propNameString);
            this.props.put(propNameString, propValue);
        }
        String propKeyJBossasBindAddress = "jboss.bind.address";
        if (this.props.get("jboss.bind.address") == null) {
            String defaultBindAddress = "127.0.0.1";
            this.props.put("jboss.bind.address", "127.0.0.1");
            System.setProperty("jboss.bind.address", "127.0.0.1");
        }
        String defaultAddress = System.getProperty("jboss.bind.address");
        ServerConfigUtil.fixRemoteAddressProperty("java.rmi.server.hostname", defaultAddress);
        ServerConfigUtil.fixRemoteAddressProperty("jgroups.bind_addr", defaultAddress);
        ServerConfigUtil.fixRemoteAddressProperty("bind.address", null);
        if (System.getProperty("jboss.vfs.forceCopy") == null) {
            System.setProperty("jboss.vfs.forceCopy", "true");
        }
    }

    public static void main(final String[] args) throws Exception {
        Runnable worker = new Runnable(){

            public void run() {
                try {
                    Main main = new Main();
                    main.boot(args);
                }
                catch (Exception e) {
                    System.err.println("Failed to boot JBoss:");
                    e.printStackTrace();
                }
            }
        };
        ThreadGroup threads = new ThreadGroup("jboss");
        new Thread(threads, worker, "main").start();
    }

    public static void systemExit(String[] argv) {
        System.exit(0);
    }

    private static class ShutdownHook
    extends Thread {
        private JBossASServer server;
        private ClassLoader serverCl;

        ShutdownHook(JBossASServer server, ClassLoader serverCl) throws IllegalArgumentException {
            if (server == null) {
                throw new IllegalArgumentException("server must be specified");
            }
            if (serverCl == null) {
                throw new IllegalArgumentException("server ClassLoader must be specified");
            }
            this.server = server;
            this.serverCl = serverCl;
        }

        public void run() {
            if (this.server != null) {
                System.out.println("Posting Shutdown Request to the server...");
                Thread shutdownThread = new Thread(){

                    public void run() {
                        try {
                            boolean cleanShutdown = false;
                            if (ShutdownHook.this.server.getState().equals((Object)LifecycleState.STARTED)) {
                                cleanShutdown = true;
                                ShutdownHook.this.server.shutdown();
                            }
                            if (ShutdownHook.this.serverCl != null && ShutdownHook.this.serverCl instanceof Closeable) {
                                try {
                                    ((Closeable)((Object)ShutdownHook.this.serverCl)).close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (!cleanShutdown) {
                                System.out.println("Server startup has not completed, so halting the process");
                                Runtime.getRuntime().halt(-1);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Exception encountered in shutting down the server", e);
                        }
                    }
                };
                shutdownThread.start();
                try {
                    shutdownThread.join();
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
            }
        }
    }

    @Deprecated
    private static class ServerConfigUtil {
        private ServerConfigUtil() {
        }

        public static String fixRemoteAddress(String address) {
            try {
                if (address == null || "0.0.0.0".equals(address)) {
                    return InetAddress.getLocalHost().getHostName();
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return address;
        }

        public static void fixRemoteAddressProperty(String systemPropertyName, String defaultValue) {
            String old = System.getProperty(systemPropertyName);
            if (old == null) {
                if (defaultValue != null) {
                    String fixed = ServerConfigUtil.fixRemoteAddress(defaultValue);
                    System.setProperty(systemPropertyName, fixed);
                }
            } else {
                String fixed = ServerConfigUtil.fixRemoteAddress(old);
                System.setProperty(systemPropertyName, fixed);
            }
        }
    }

    static class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

