/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static void setSystemProperty(final String key, final String value) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(key, value);
                return null;
            }
        });
    }

    static String getSystemProperty(final String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key was null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setThreadContextClassLoader(final ClassLoader cl) throws IllegalArgumentException {
        if (cl == null) {
            throw new IllegalArgumentException("ClassLoader was null");
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    static void addShutdownHook(final Thread shutdownHook) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                return null;
            }
        });
    }
}

