/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.statistics;

import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JCAConnectionPoolStats;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.TimeStatistic;
import org.jboss.management.j2ee.statistics.CountStatisticImpl;
import org.jboss.management.j2ee.statistics.JCAConnectionStatsImpl;
import org.jboss.management.j2ee.statistics.RangeStatisticImpl;

public class JCAConnectionPoolStatsImpl
extends JCAConnectionStatsImpl
implements JCAConnectionPoolStats {
    private static final long serialVersionUID = 6867747857618271195L;

    public JCAConnectionPoolStatsImpl(String cfName, String mcfName, BoundedRangeStatistic freePoolSize, BoundedRangeStatistic poolSize) {
        this(cfName, mcfName, null, null, null, null, freePoolSize, poolSize, null);
    }

    public JCAConnectionPoolStatsImpl(String cfName, String mcfName, TimeStatistic waitTime, TimeStatistic useTime, CountStatistic closeCount, CountStatistic createCount, BoundedRangeStatistic freePoolSize, BoundedRangeStatistic poolSize, RangeStatistic waitingThreadCount) {
        super(cfName, mcfName, waitTime, useTime);
        if (closeCount == null) {
            closeCount = new CountStatisticImpl("CloseCount", "1", "The number of connection closes");
        }
        if (createCount == null) {
            createCount = new CountStatisticImpl("CreateCount", "1", "The number of connection creates");
        }
        if (waitingThreadCount == null) {
            waitingThreadCount = new RangeStatisticImpl("WaitingThreadCount", "1", "The number of threads waiting for a connection");
        }
        super.addStatistic("CloseCount", closeCount);
        super.addStatistic("CreateCount", createCount);
        super.addStatistic("FreePoolSize", freePoolSize);
        super.addStatistic("PoolSize", poolSize);
        super.addStatistic("WaitingThreadCount", waitingThreadCount);
    }

    public CountStatistic getCloseCount() {
        CountStatistic cs = (CountStatistic)this.getStatistic("CloseCount");
        return cs;
    }

    public CountStatistic getCreateCount() {
        CountStatistic cs = (CountStatistic)this.getStatistic("CreateCount");
        return cs;
    }

    public BoundedRangeStatistic getFreePoolSize() {
        BoundedRangeStatistic brs = (BoundedRangeStatistic)this.getStatistic("FreePoolSize");
        return brs;
    }

    public BoundedRangeStatistic getPoolSize() {
        BoundedRangeStatistic brs = (BoundedRangeStatistic)this.getStatistic("PoolSize");
        return brs;
    }

    public RangeStatistic getWaitingThreadCount() {
        RangeStatistic rs = (RangeStatistic)this.getStatistic("WaitingThreadCount");
        return rs;
    }
}

