/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.mx.mxbean.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.mx.mxbean.support.TestEnum;
import org.jboss.test.mx.mxbean.test.CompositeDataTest;

public class CompositeDataArrayUnitTestCase
extends CompositeDataTest {
    public static Test suite() {
        return new TestSuite(CompositeDataArrayUnitTestCase.class);
    }

    public CompositeDataArrayUnitTestCase(String name) {
        super(name);
    }

    public void testArrayString() throws Exception {
        String[] array = new String[]{"one", "two", "three"};
        this.constructReconstructTest(array);
    }

    public void testMultiArrayString() throws Exception {
        String[][] array = new String[][]{{"one", "two", "three"}, {"four", "five", "six"}};
        this.constructReconstructTest(array);
    }

    public void testArrayEnum() throws Exception {
        TestEnum[] array = new TestEnum[]{TestEnum.FIRST, TestEnum.SECOND};
        String[] openData = new String[]{TestEnum.FIRST.name(), TestEnum.SECOND.name()};
        this.constructReconstructTest((Object)array, openData);
    }

    public void testMultiArrayEnum() throws Exception {
        TestEnum[][] array = new TestEnum[][]{{TestEnum.FIRST, TestEnum.SECOND}, {TestEnum.SECOND}};
        String[][] openData = new String[][]{{TestEnum.FIRST.name(), TestEnum.SECOND.name()}, {TestEnum.SECOND.name()}};
        this.constructReconstructTest((Object)array, openData);
    }

    public void testArrayNull() throws Exception {
        this.constructReconstructTest(null, new String[0].getClass());
    }

    public void testArrayElementNull() throws Exception {
        TestEnum[] array = new TestEnum[]{TestEnum.FIRST, null};
        String[] openData = new String[]{TestEnum.FIRST.name(), null};
        this.constructReconstructTest((Object)array, openData);
    }

    public void testMultiArrayElementNull() throws Exception {
        TestEnum[][] array = new TestEnum[][]{{TestEnum.FIRST, null}, {TestEnum.SECOND}};
        String[][] openData = new String[][]{{TestEnum.FIRST.name(), null}, {TestEnum.SECOND.name()}};
        this.constructReconstructTest((Object)array, openData);
    }

    public void testMultiArrayNull() throws Exception {
        TestEnum[][] array = new TestEnum[][]{{TestEnum.FIRST, TestEnum.SECOND}, null, {TestEnum.SECOND}};
        String[][] openData = new String[][]{{TestEnum.FIRST.name(), TestEnum.SECOND.name()}, null, {TestEnum.SECOND.name()}};
        this.constructReconstructTest((Object)array, openData);
    }

    public void checkEquals(Object expected, Object actual) {
        CompositeDataArrayUnitTestCase.checkArrayEquals(expected, actual);
    }
}

