/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.mx.mxbean.test;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.mx.mxbean.support.TestParameterizedType;
import org.jboss.test.mx.mxbean.test.CompositeDataTest;

public class CompositeDataCollectionUnitTestCase
extends CompositeDataTest {
    private static final TestParameterizedType COLLECTION_OF_STRINGS = new TestParameterizedType((Type)((Object)Collection.class), new Type[]{String.class});
    private static final TestParameterizedType LIST_OF_STRINGS = new TestParameterizedType((Type)((Object)List.class), new Type[]{String.class});
    private static final TestParameterizedType SET_OF_STRINGS = new TestParameterizedType((Type)((Object)Set.class), new Type[]{String.class});

    public static Test suite() {
        return new TestSuite(CompositeDataCollectionUnitTestCase.class);
    }

    public CompositeDataCollectionUnitTestCase(String name) {
        super(name);
    }

    public void testCollection() throws Exception {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("two");
        c.add("three");
        String[] openData = new String[]{"one", "two", "three"};
        this.constructReconstructTest(c, COLLECTION_OF_STRINGS, (Object)openData);
    }

    public void testCollectionNull() throws Exception {
        this.constructReconstructTest(null, COLLECTION_OF_STRINGS);
    }

    public void testCollectionContainsNull() throws Exception {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add(null);
        c.add("three");
        String[] openData = new String[]{"one", null, "three"};
        this.constructReconstructTest(c, COLLECTION_OF_STRINGS, (Object)openData);
    }

    public void testList() throws Exception {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("two");
        c.add("three");
        String[] openData = new String[]{"one", "two", "three"};
        this.constructReconstructTest(c, LIST_OF_STRINGS, (Object)openData);
    }

    public void testListNull() throws Exception {
        this.constructReconstructTest(null, LIST_OF_STRINGS);
    }

    public void testListContainsNull() throws Exception {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add(null);
        c.add("three");
        String[] openData = new String[]{"one", null, "three"};
        this.constructReconstructTest(c, LIST_OF_STRINGS, (Object)openData);
    }

    public void testSet() throws Exception {
        LinkedHashSet<String> c = new LinkedHashSet<String>();
        c.add("one");
        c.add("two");
        c.add("three");
        String[] openData = new String[]{"one", "two", "three"};
        this.constructReconstructTest(c, SET_OF_STRINGS, (Object)openData);
    }

    public void testSetNull() throws Exception {
        this.constructReconstructTest(null, SET_OF_STRINGS);
    }

    public void testSetContainsNull() throws Exception {
        LinkedHashSet<String> c = new LinkedHashSet<String>();
        c.add("one");
        c.add(null);
        c.add("three");
        String[] openData = new String[]{"one", null, "three"};
        this.constructReconstructTest(c, SET_OF_STRINGS, (Object)openData);
    }

    protected void checkOpenDataEquals(Object expected, Object actual) {
        CompositeDataCollectionUnitTestCase.checkArrayEquals(expected, actual);
    }
}

