/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.mx.mxbean.test;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.mx.mxbean.CompositeDataInvocationHandler;
import org.jboss.test.mx.mxbean.support.InvalidInterface;
import org.jboss.test.mx.mxbean.support.SimpleInterface;
import org.jboss.test.mx.mxbean.test.AbstractMXBeanTest;

public class CompositeDataInvocationHandlerUnitTestCase
extends AbstractMXBeanTest {
    public static Test suite() {
        return new TestSuite(CompositeDataInvocationHandlerUnitTestCase.class);
    }

    public CompositeDataInvocationHandlerUnitTestCase(String name) {
        super(name);
    }

    public void testGetCompositeData() throws Exception {
        CompositeDataInvocationHandler test;
        CompositeData compositeData = this.createTestCompositeData();
        CompositeDataInvocationHandlerUnitTestCase.assertTrue((compositeData == (test = new CompositeDataInvocationHandler(compositeData)).getCompositeData() ? 1 : 0) != 0);
    }

    public void testNullCompositeData() throws Exception {
        try {
            new CompositeDataInvocationHandler(null);
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)t);
        }
    }

    public void testToEquals() throws Exception {
        SimpleInterface test1 = this.createTestCompositeDataProxy("Test1");
        CompositeDataInvocationHandlerUnitTestCase.assertFalse((boolean)test1.equals(null));
        CompositeDataInvocationHandlerUnitTestCase.assertFalse((boolean)test1.equals(new Object()));
        CompositeDataInvocationHandlerUnitTestCase.assertTrue((boolean)test1.equals(test1));
        SimpleInterface test2 = this.createTestCompositeDataProxy("Test2");
        CompositeDataInvocationHandlerUnitTestCase.assertFalse((boolean)test1.equals(test2));
    }

    public void testHashCode() throws Exception {
        CompositeData compositeData = this.createTestCompositeData();
        SimpleInterface test = this.createCompositeDataProxy(SimpleInterface.class, compositeData);
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((int)test.hashCode(), (int)((Object)compositeData).hashCode());
    }

    public void testToString() throws Exception {
        CompositeData compositeData = this.createTestCompositeData();
        SimpleInterface test = this.createCompositeDataProxy(SimpleInterface.class, compositeData);
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((String)test.toString(), (String)((Object)compositeData).toString());
    }

    public void testGetSimpleTypes() throws Exception {
        SimpleInterface test = this.createTestCompositeDataProxy();
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.bigDecimalValue, (Object)test.getBigDecimal());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.bigIntegerValue, (Object)test.getBigInteger());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.booleanValue, (Object)test.getBoolean());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((boolean)SimpleInterface.primitiveBooleanValue, (boolean)test.isPrimitiveBoolean());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.byteValue, (Object)test.getByte());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((byte)SimpleInterface.primitiveByteValue, (byte)test.getPrimitiveByte());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.characterValue, (Object)test.getCharacter());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((char)SimpleInterface.primitiveCharValue, (char)test.getPrimitiveChar());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.dateValue, (Object)test.getDate());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.doubleValue, (Object)test.getDouble());
        this.assertEquals(SimpleInterface.primitiveDoubleValue, test.getPrimitiveDouble());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.floatValue, (Object)test.getFloat());
        this.assertEquals(SimpleInterface.primitiveFloatValue, test.getPrimitiveFloat());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.integerValue, (Object)test.getInteger());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((int)SimpleInterface.primitiveIntValue, (int)test.getPrimitiveInt());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.longValue, (Object)test.getLong());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((long)SimpleInterface.primitiveLongValue, (long)test.getPrimitiveLong());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.objectNameValue, (Object)test.getObjectName());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((Object)SimpleInterface.shortValue, (Object)test.getShort());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((short)SimpleInterface.primitiveShortValue, (short)test.getPrimitiveShort());
        CompositeDataInvocationHandlerUnitTestCase.assertEquals((String)SimpleInterface.stringValue, (String)test.getString());
    }

    public void testNullPrimitives() throws Exception {
        SimpleInterface test = this.createNullCompositeDataProxy();
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getBigDecimal());
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getBigInteger());
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getBoolean());
        try {
            test.isPrimitiveBoolean();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getByte());
        try {
            test.getPrimitiveByte();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getCharacter());
        try {
            test.getPrimitiveChar();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getDate());
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getDouble());
        try {
            test.getPrimitiveDouble();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getFloat());
        try {
            test.getPrimitiveFloat();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getInteger());
        try {
            test.getPrimitiveInt();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getLong());
        try {
            test.getPrimitiveLong();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getObjectName());
        CompositeDataInvocationHandlerUnitTestCase.assertNull((Object)test.getShort());
        try {
            test.getPrimitiveShort();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
        CompositeDataInvocationHandlerUnitTestCase.assertNull((String)SimpleInterface.stringValue, (Object)test.getString());
    }

    public void testGetInvalid() throws Exception {
        InvalidInterface test = this.createInvalidCompositeDataProxy();
        try {
            test.getInvalid();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, InvalidKeyException.class, t);
        }
    }

    public void testNotAGetter() throws Exception {
        InvalidInterface test = this.createInvalidCompositeDataProxy();
        try {
            test.notAGetter();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
    }

    public void testGetNoReturnType() throws Exception {
        InvalidInterface test = this.createInvalidCompositeDataProxy();
        try {
            test.getString();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
    }

    public void testGetWithParameters() throws Exception {
        InvalidInterface test = this.createInvalidCompositeDataProxy();
        try {
            test.getString(null);
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
    }

    public void testIsNotBoolean() throws Exception {
        InvalidInterface test = this.createInvalidCompositeDataProxy();
        try {
            test.isString();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
    }

    public void testIsBoolean() throws Exception {
        InvalidInterface test = this.createInvalidCompositeDataProxy();
        try {
            test.isBoolean();
            CompositeDataInvocationHandlerUnitTestCase.fail((String)"Should not be here");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            CompositeDataInvocationHandlerUnitTestCase.checkThrowableDeep(IllegalArgumentException.class, t);
        }
    }
}

