/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.mx.mxbean.test;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.mx.mxbean.MXBeanUtils;
import org.jboss.test.mx.mxbean.support.TestParameterizedType;
import org.jboss.test.mx.mxbean.test.CompositeDataTest;

public class CompositeDataMapUnitTestCase
extends CompositeDataTest {
    private static final TestParameterizedType MAP_OF_STRINGS_TO_INTEGERS = new TestParameterizedType((Type)((Object)Map.class), new Type[]{String.class, Integer.class});
    private static final TabularType TABLE_STRING_TO_INTEGER = MXBeanUtils.createMapType(String.class, Integer.class);

    public static Test suite() {
        return new TestSuite(CompositeDataMapUnitTestCase.class);
    }

    public CompositeDataMapUnitTestCase(String name) {
        super(name);
    }

    public void testMap() throws Exception {
        LinkedHashMap<String, Integer> c = new LinkedHashMap<String, Integer>();
        c.put("one", 1);
        c.put("two", 2);
        c.put("three", 3);
        TabularDataSupport openData = new TabularDataSupport(TABLE_STRING_TO_INTEGER);
        CompositeType entryType = TABLE_STRING_TO_INTEGER.getRowType();
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{"one", 1}));
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{"two", 2}));
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{"three", 3}));
        this.constructReconstructTest(c, MAP_OF_STRINGS_TO_INTEGERS, (Object)openData);
    }

    public void testMapNull() throws Exception {
        this.constructReconstructTest(null, MAP_OF_STRINGS_TO_INTEGERS);
    }

    public void testMapNullKey() throws Exception {
        LinkedHashMap<String, Integer> c = new LinkedHashMap<String, Integer>();
        c.put("one", 1);
        c.put(null, 2);
        c.put("three", 3);
        TabularDataSupport openData = new TabularDataSupport(TABLE_STRING_TO_INTEGER);
        CompositeType entryType = TABLE_STRING_TO_INTEGER.getRowType();
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{"one", 1}));
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{null, 2}));
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{"three", 3}));
        this.constructReconstructTest(c, MAP_OF_STRINGS_TO_INTEGERS, (Object)openData);
    }

    public void testMapNullValue() throws Exception {
        LinkedHashMap<String, Integer> c = new LinkedHashMap<String, Integer>();
        c.put("one", 1);
        c.put("two", null);
        c.put("three", 3);
        TabularDataSupport openData = new TabularDataSupport(TABLE_STRING_TO_INTEGER);
        CompositeType entryType = TABLE_STRING_TO_INTEGER.getRowType();
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{"one", 1}));
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{"two", null}));
        openData.put(new CompositeDataSupport(entryType, MXBeanUtils.MAP_ITEM_NAMES, new Object[]{"three", 3}));
        this.constructReconstructTest(c, MAP_OF_STRINGS_TO_INTEGERS, (Object)openData);
    }
}

