/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.mx.mxbean.test;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.mx.mxbean.MXBeanFactory;
import org.jboss.mx.mxbean.MXBeanUtils;
import org.jboss.test.mx.mxbean.support.CollectionsInterface;
import org.jboss.test.mx.mxbean.support.CollectionsMXBeanSupport;
import org.jboss.test.mx.mxbean.support.CollectionsMXBeanSupportMXBean;
import org.jboss.test.mx.mxbean.support.CompositeInterface;
import org.jboss.test.mx.mxbean.support.CompositeMXBeanSupport;
import org.jboss.test.mx.mxbean.support.CompositeMXBeanSupportMXBean;
import org.jboss.test.mx.mxbean.support.SimpleInterface;
import org.jboss.test.mx.mxbean.support.SimpleMXBeanSupport;
import org.jboss.test.mx.mxbean.support.SimpleMXBeanSupportMXBean;
import org.jboss.test.mx.mxbean.support.SimpleObject;
import org.jboss.test.mx.mxbean.support.TestEnum;
import org.jboss.test.mx.mxbean.test.AbstractMXBeanTest;

public class MXBeanInvocationHandlerUnitTestCase
extends AbstractMXBeanTest {
    public static Test suite() {
        return new TestSuite(MXBeanInvocationHandlerUnitTestCase.class);
    }

    public MXBeanInvocationHandlerUnitTestCase(String name) {
        super(name);
    }

    public void testGetSimpleAttributes() throws Exception {
        MBeanServer server = this.createMBeanServer();
        SimpleMXBeanSupport support = new SimpleMXBeanSupport();
        ObjectName objectName = SimpleMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        SimpleMXBeanSupportMXBean proxy = (SimpleMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, SimpleMXBeanSupportMXBean.class);
        OpenMBeanInfo info = (OpenMBeanInfo)((Object)server.getMBeanInfo(objectName));
        OpenType[] types = new OpenType[SimpleInterface.TYPES.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = MXBeanUtils.getOpenType((Type)SimpleInterface.TYPES[i]);
        }
        this.checkAttributes(SimpleMXBeanSupportMXBean.class, proxy, support, SimpleInterface.KEYS, types, SimpleInterface.VALUES, info);
    }

    public void testSetSimpleAttributes() throws Exception {
        MBeanServer server = this.createMBeanServer();
        SimpleMXBeanSupport support = new SimpleMXBeanSupport();
        ObjectName objectName = SimpleMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        SimpleMXBeanSupportMXBean proxy = (SimpleMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, SimpleMXBeanSupportMXBean.class);
        OpenMBeanInfo info = (OpenMBeanInfo)((Object)server.getMBeanInfo(objectName));
        OpenType[] types = new OpenType[SimpleInterface.TYPES.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = MXBeanUtils.getOpenType((Type)SimpleInterface.TYPES[i]);
        }
        proxy.setBigDecimal(SimpleInterface.bigDecimalChangedValue);
        proxy.setBigInteger(SimpleInterface.bigIntegerChangedValue);
        proxy.setBoolean(SimpleInterface.booleanChangedValue);
        proxy.setByte(SimpleInterface.byteChangedValue);
        proxy.setCharacter(SimpleInterface.characterChangedValue);
        proxy.setDate(SimpleInterface.dateChangedValue);
        proxy.setDouble(SimpleInterface.doubleChangedValue);
        proxy.setFloat(SimpleInterface.floatChangedValue);
        proxy.setInteger(SimpleInterface.integerChangedValue);
        proxy.setLong(SimpleInterface.longChangedValue);
        proxy.setObjectName(SimpleInterface.objectNameChangedValue);
        proxy.setPrimitiveBoolean(SimpleInterface.primitiveBooleanChangedValue);
        proxy.setPrimitiveByte(SimpleInterface.primitiveByteChangedValue);
        proxy.setPrimitiveChar(SimpleInterface.primitiveCharChangedValue);
        proxy.setPrimitiveDouble(SimpleInterface.primitiveDoubleChangedValue);
        proxy.setPrimitiveFloat(SimpleInterface.primitiveFloatChangedValue);
        proxy.setPrimitiveInt(SimpleInterface.primitiveIntChangedValue);
        proxy.setPrimitiveLong(SimpleInterface.primitiveLongChangedValue);
        proxy.setPrimitiveShort(SimpleInterface.primitiveShortChangedValue);
        proxy.setShort(SimpleInterface.shortChangedValue);
        proxy.setString(SimpleInterface.stringChangedValue);
        this.checkAttributes(SimpleInterface.class, proxy, support, SimpleInterface.KEYS, types, SimpleInterface.CHANGED_VALUES, info);
    }

    public void testSimpleInvoke() throws Exception {
        MBeanServer server = this.createMBeanServer();
        SimpleMXBeanSupport support = new SimpleMXBeanSupport();
        ObjectName objectName = SimpleMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        SimpleMXBeanSupportMXBean proxy = (SimpleMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, SimpleMXBeanSupportMXBean.class);
        MXBeanInvocationHandlerUnitTestCase.assertEquals((String)"olleH", (String)proxy.echoReverse("Hello"));
    }

    public void testGetCompositeAttributes() throws Exception {
        MBeanServer server = this.createMBeanServer();
        SimpleObject composite = new SimpleObject();
        CompositeMXBeanSupport support = new CompositeMXBeanSupport("Simple", composite);
        ObjectName objectName = CompositeMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        CompositeMXBeanSupportMXBean proxy = (CompositeMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, CompositeMXBeanSupportMXBean.class);
        OpenMBeanInfo info = (OpenMBeanInfo)((Object)server.getMBeanInfo(objectName));
        Object[] values = new Object[]{"Simple", composite};
        this.checkAttributes(CompositeMXBeanSupportMXBean.class, proxy, support, CompositeInterface.KEYS, CompositeInterface.TYPES, values, info);
    }

    public void testSetCompositeAttributes() throws Exception {
        MBeanServer server = this.createMBeanServer();
        SimpleObject composite = new SimpleObject();
        CompositeMXBeanSupport support = new CompositeMXBeanSupport("Simple", composite);
        ObjectName objectName = CompositeMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        CompositeMXBeanSupportMXBean proxy = (CompositeMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, CompositeMXBeanSupportMXBean.class);
        OpenMBeanInfo info = (OpenMBeanInfo)((Object)server.getMBeanInfo(objectName));
        SimpleObject changed = new SimpleObject();
        changed.setBigDecimal(SimpleInterface.bigDecimalChangedValue);
        changed.setBigInteger(SimpleInterface.bigIntegerChangedValue);
        changed.setBoolean(SimpleInterface.booleanChangedValue);
        changed.setByte(SimpleInterface.byteChangedValue);
        changed.setCharacter(SimpleInterface.characterChangedValue);
        changed.setDate(SimpleInterface.dateChangedValue);
        changed.setDouble(SimpleInterface.doubleChangedValue);
        changed.setFloat(SimpleInterface.floatChangedValue);
        changed.setInteger(SimpleInterface.integerChangedValue);
        changed.setLong(SimpleInterface.longChangedValue);
        changed.setObjectName(SimpleInterface.objectNameChangedValue);
        changed.setPrimitiveBoolean(SimpleInterface.primitiveBooleanChangedValue);
        changed.setPrimitiveByte(SimpleInterface.primitiveByteChangedValue);
        changed.setPrimitiveChar(SimpleInterface.primitiveCharChangedValue);
        changed.setPrimitiveDouble(SimpleInterface.primitiveDoubleChangedValue);
        changed.setPrimitiveFloat(SimpleInterface.primitiveFloatChangedValue);
        changed.setPrimitiveInt(SimpleInterface.primitiveIntChangedValue);
        changed.setPrimitiveLong(SimpleInterface.primitiveLongChangedValue);
        changed.setPrimitiveShort(SimpleInterface.primitiveShortChangedValue);
        changed.setShort(SimpleInterface.shortChangedValue);
        changed.setString(SimpleInterface.stringChangedValue);
        proxy.setSimple("Changed");
        proxy.setComposite(changed);
        Object[] values = new Object[]{"Changed", changed};
        this.checkAttributes(CompositeMXBeanSupportMXBean.class, proxy, support, CompositeInterface.KEYS, CompositeInterface.TYPES, values, info);
    }

    public void testCompositeInvoke() throws Exception {
        MBeanServer server = this.createMBeanServer();
        SimpleObject composite = new SimpleObject();
        CompositeMXBeanSupport support = new CompositeMXBeanSupport("Simple", composite);
        ObjectName objectName = CompositeMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        CompositeMXBeanSupportMXBean proxy = (CompositeMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, CompositeMXBeanSupportMXBean.class);
        composite = new SimpleObject();
        composite.setString("hello");
        SimpleInterface result = proxy.echoReverse(composite);
        MXBeanInvocationHandlerUnitTestCase.assertEquals((String)"olleh", (String)result.getString());
    }

    public void testGetCollectionAttributes() throws Exception {
        MBeanServer server = this.createMBeanServer();
        String[] array = new String[]{"array"};
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("collection");
        HashSet<String> set = new HashSet<String>();
        set.add("set");
        ArrayList<String> list = new ArrayList<String>();
        list.add("list");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("map", 1);
        TestEnum enumeration = TestEnum.FIRST;
        CollectionsMXBeanSupport support = new CollectionsMXBeanSupport(array, collection, set, list, map, enumeration);
        ObjectName objectName = CollectionsMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        CollectionsMXBeanSupportMXBean proxy = (CollectionsMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, CollectionsMXBeanSupportMXBean.class);
        OpenMBeanInfo info = (OpenMBeanInfo)((Object)server.getMBeanInfo(objectName));
        Object[] values = new Object[]{array, collection, set, list, map, enumeration};
        this.checkAttributes(CollectionsMXBeanSupportMXBean.class, proxy, support, CollectionsInterface.KEYS, CollectionsInterface.TYPES, values, info);
    }

    public void testSetCollectionAttributes() throws Exception {
        MBeanServer server = this.createMBeanServer();
        String[] array = new String[]{"array"};
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("collection");
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("set");
        ArrayList<String> list = new ArrayList<String>();
        list.add("list");
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.put("map", 1);
        TestEnum enumeration = TestEnum.FIRST;
        CollectionsMXBeanSupport support = new CollectionsMXBeanSupport(array, collection, set, list, map, enumeration);
        ObjectName objectName = CollectionsMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        CollectionsMXBeanSupportMXBean proxy = (CollectionsMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, CollectionsMXBeanSupportMXBean.class);
        OpenMBeanInfo info = (OpenMBeanInfo)((Object)server.getMBeanInfo(objectName));
        String[] changedArray = new String[]{"arrayChanged"};
        ArrayList<String> changedCollection = new ArrayList<String>();
        changedCollection.add("collectionChanged");
        LinkedHashSet<String> changedSet = new LinkedHashSet<String>();
        changedSet.add("setChanged");
        ArrayList<String> changedList = new ArrayList<String>();
        changedList.add("listChanged");
        LinkedHashMap<String, Integer> changedMap = new LinkedHashMap<String, Integer>();
        changedMap.put("mapChanged", 2);
        TestEnum changedEnumeration = TestEnum.SECOND;
        proxy.setArray(changedArray);
        proxy.setCollection(changedCollection);
        proxy.setEnum(changedEnumeration);
        proxy.setList(changedList);
        proxy.setMap(changedMap);
        proxy.setSet(changedSet);
        Object[] changedValues = new Object[]{changedArray, changedCollection, changedSet, changedList, changedMap, changedEnumeration};
        this.checkAttributes(CollectionsMXBeanSupportMXBean.class, proxy, support, CollectionsInterface.KEYS, CollectionsInterface.TYPES, changedValues, info);
    }

    public void testCollectionInvoke() throws Exception {
        MBeanServer server = this.createMBeanServer();
        CollectionsMXBeanSupport support = new CollectionsMXBeanSupport();
        ObjectName objectName = CompositeMXBeanSupportMXBean.REGISTERED_OBJECT_NAME;
        server.registerMBean(support, objectName);
        CollectionsMXBeanSupportMXBean proxy = (CollectionsMXBeanSupportMXBean)MXBeanFactory.makeProxy((MBeanServerConnection)server, (ObjectName)objectName, CollectionsMXBeanSupportMXBean.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("three");
        expected.add("two");
        expected.add("one");
        List<String> result = proxy.echoReverse(list);
        MXBeanInvocationHandlerUnitTestCase.assertEquals(expected, result);
    }

    protected void checkAttributes(Class intf, Object proxy, Object mxbean, String[] keys, OpenType[] types, Object[] values, OpenMBeanInfo info) throws Exception {
        int i;
        MBeanAttributeInfo[] attributes = info.getAttributes();
        MXBeanInvocationHandlerUnitTestCase.assertEquals((int)keys.length, (int)values.length);
        MXBeanInvocationHandlerUnitTestCase.assertEquals((int)keys.length, (int)types.length);
        MXBeanInvocationHandlerUnitTestCase.assertEquals((int)keys.length, (int)attributes.length);
        HashMap<String, OpenMBeanAttributeInfo> mapping = new HashMap<String, OpenMBeanAttributeInfo>(attributes.length);
        for (i = 0; i < attributes.length; ++i) {
            OpenMBeanAttributeInfo attribute = (OpenMBeanAttributeInfo)((Object)attributes[i]);
            String name = attribute.getName();
            mapping.put(name, attribute);
        }
        for (i = 0; i < keys.length; ++i) {
            String name = MXBeanInvocationHandlerUnitTestCase.getUpperName(keys[i]);
            OpenMBeanAttributeInfo attribute = (OpenMBeanAttributeInfo)mapping.get(name);
            MXBeanInvocationHandlerUnitTestCase.assertNotNull((String)("Could not find key " + name + " in " + mapping.keySet()), (Object)attribute);
            Method method = MXBeanUtils.getCompositeDataMethod((Class)intf, (String)keys[i], (types[i] == SimpleType.BOOLEAN ? 1 : 0) != 0);
            Object value = method.invoke(proxy, null);
            MXBeanInvocationHandlerUnitTestCase.checkValueEquals(values[i], value);
            value = method.invoke(mxbean, null);
            MXBeanInvocationHandlerUnitTestCase.checkValueEquals(values[i], value);
            MXBeanInvocationHandlerUnitTestCase.assertEquals((Object)types[i], attribute.getOpenType());
        }
    }
}

