/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.integration.deployers;

import java.util.ArrayList;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.resteasy.integration.deployers.ResteasyDeploymentData;
import org.jboss.resteasy.plugins.server.servlet.FilterDispatcher;

public class ResteasyIntegrationDeployer
extends AbstractRealDeployer {
    private static final Logger LOGGER = Logger.getLogger(ResteasyIntegrationDeployer.class);

    public ResteasyIntegrationDeployer() {
        this.addRequiredInput(JBossWebMetaData.class);
        this.addRequiredInput(ResteasyDeploymentData.class);
        this.addOutput(JBossWebMetaData.class);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    protected void populateWebMetadata() {
    }

    protected void setInitParam(FilterMetaData filter, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = filter.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            filter.setInitParam(params);
        }
        params.add(param);
    }

    protected void internalDeploy(DeploymentUnit du) throws DeploymentException {
        StringBuffer buf;
        JBossWebMetaData webdata = (JBossWebMetaData)du.getAttachment(JBossWebMetaData.class);
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)du.getAttachment(ResteasyDeploymentData.class);
        if (!resteasy.shouldCreateDispatcher()) {
            return;
        }
        FilterMetaData filter = new FilterMetaData();
        filter.setFilterClass(FilterDispatcher.class.getName());
        filter.setName("Resteasy");
        if (!resteasy.getResources().isEmpty()) {
            buf = null;
            for (String resource : resteasy.getResources()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(resource);
                } else {
                    buf.append(",").append(resource);
                }
                this.log.info((Object)("******** Adding RESOURCE CLASS: " + resource));
            }
            String resources = buf.toString();
            this.setInitParam(filter, "resteasy.resources", resources);
        }
        if (!resteasy.getProviders().isEmpty()) {
            buf = null;
            for (String provider : resteasy.getProviders()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(provider);
                    continue;
                }
                buf.append(",").append(provider);
            }
            this.setInitParam(filter, "resteasy.providers", buf.toString());
        }
        FilterMappingMetaData mapping = new FilterMappingMetaData();
        mapping.setFilterName("Resteasy");
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add("/*");
        mapping.setUrlPatterns(patterns);
        if (webdata.getFilters() == null) {
            webdata.setFilters(new FiltersMetaData());
        }
        webdata.getFilters().add((MappableMetaData)filter);
        ArrayList<FilterMappingMetaData> mappings = webdata.getFilterMappings();
        if (mappings == null) {
            mappings = new ArrayList<FilterMappingMetaData>();
            webdata.setFilterMappings(mappings);
        }
        mappings.add(mapping);
    }
}

