/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.integration.deployers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.resteasy.integration.deployers.ResteasyDeploymentScanningData;
import org.jboss.resteasy.integration.deployers.ResteasyIntegrationDeployer;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrapClasses;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.annotations.spi.AnnotationRepository;
import org.jboss.scanning.annotations.spi.Element;
import org.jboss.scanning.hierarchy.spi.HierarchyIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyScannerDeployer
extends AbstractRealDeployer {
    private static final Logger LOGGER = Logger.getLogger(ResteasyScannerDeployer.class);
    public static final Set<String> BOOT_CLASSES = new HashSet<String>();

    public ResteasyScannerDeployer() {
        this.addRequiredInput(JBossWebMetaData.class);
        this.addInput(AnnotationRepository.class);
        this.addOutput(JBossWebMetaData.class);
        this.addOutput(ResteasyDeploymentScanningData.class);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    protected void internalDeploy(DeploymentUnit du) throws DeploymentException {
        JBossWebMetaData webdata = (JBossWebMetaData)du.getAttachment(JBossWebMetaData.class);
        boolean applicationClassDeployed = this.deployApplicationClass(du, webdata);
        if (applicationClassDeployed) {
            return;
        }
        this.scan(du, webdata);
    }

    protected boolean hasBootClasses(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        ClassLoader loader = du.getClassLoader();
        if (webdata.getServlets() != null) {
            for (JBossServletMetaData servlet : webdata.getServlets()) {
                String servletClass = servlet.getServletClass();
                if (!BOOT_CLASSES.contains(servletClass)) continue;
                return true;
            }
        }
        if (webdata.getFilters() != null) {
            for (FilterMetaData filter : webdata.getFilters()) {
                if (!BOOT_CLASSES.contains(filter.getFilterClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean deployApplicationClass(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        ClassLoader loader = du.getClassLoader();
        if (webdata.getServlets() == null) {
            return false;
        }
        for (JBossServletMetaData servlet : webdata.getServlets()) {
            String servletClass = servlet.getServletClass();
            if (servletClass == null) continue;
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(servletClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException((Throwable)e);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            ParamValueMetaData param = new ParamValueMetaData();
            param.setParamName("javax.ws.rs.Application");
            param.setParamValue(servletClass);
            ArrayList<ParamValueMetaData> params = servlet.getInitParam();
            if (params == null) {
                params = new ArrayList<ParamValueMetaData>();
                servlet.setInitParam(params);
            }
            params.add(param);
            ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.unwrapped.exceptions", "javax.ejb.EJBException");
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.jboss.resteasy.cdi.CdiInjectorFactory");
                if (((VFSDeploymentUnit)du).getMetaDataFile("beans.xml") != null) {
                    ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.injector.factory", "org.jboss.resteasy.cdi.CdiInjectorFactory");
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    protected void addApplicationClass(Class<? extends Application> applicationClass, DeploymentUnit du, JBossWebMetaData webdata) {
    }

    protected void scan(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        ResteasyDeploymentScanningData scanningData = new ResteasyDeploymentScanningData();
        boolean hasBoot = this.hasBootClasses(du, webdata);
        scanningData.setBootClasses(hasBoot);
        if (!hasBoot && !webdata.isMetadataComplete()) {
            scanningData.setScanAll(true);
            scanningData.setScanProviders(true);
            scanningData.setScanResources(true);
        }
        List contextParams = webdata.getContextParams();
        boolean hasResourceParam = false;
        boolean hasProviderParam = false;
        boolean hasJndiParam = false;
        if (contextParams != null) {
            for (ParamValueMetaData param : contextParams) {
                if (param.getParamName().equals("resteasy.scan")) {
                    scanningData.setScanAll(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.providers")) {
                    scanningData.setScanProviders(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.resources")) {
                    scanningData.setScanResources(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.resources")) {
                    hasResourceParam = true;
                    continue;
                }
                if (param.getParamName().equals("resteasy.providers")) {
                    hasProviderParam = true;
                    continue;
                }
                if (!param.getParamName().equals("resteasy.jndi.resources")) continue;
                hasJndiParam = true;
            }
        }
        if (hasResourceParam) {
            scanningData.setScanAll(false);
            scanningData.setScanResources(false);
        }
        if (hasProviderParam) {
            scanningData.setScanAll(false);
            scanningData.setScanProviders(false);
        }
        if (!scanningData.shouldScan()) {
            if ((hasResourceParam || hasProviderParam || hasJndiParam) && !hasBoot) {
                scanningData.createDispatcher();
                du.addAttachment(ResteasyDeploymentScanningData.class, (Object)scanningData);
            }
            return;
        }
        du.addAttachment(ResteasyDeploymentScanningData.class, (Object)scanningData);
        HierarchyIndex hier = (HierarchyIndex)du.getAttachment(HierarchyIndex.class);
        if (hier != null) {
            Set applicationClass = hier.getSubClassesOf(null, Application.class);
            if (applicationClass != null) {
                if (applicationClass.size() > 1) {
                    StringBuilder builder = new StringBuilder("Only one JAX-RS Application Class allowed.");
                    for (Class c : applicationClass) {
                        builder.append(" ").append(c.getName());
                    }
                    throw new DeploymentException(builder.toString());
                }
                if (applicationClass.size() == 1) {
                    Class aClass = (Class)applicationClass.iterator().next();
                    scanningData.setApplicationClass(aClass);
                    return;
                }
            }
        } else {
            LOGGER.debug((Object)"Expecting HierarchyIndex class for scanning WAR for JAX-RS Application class");
        }
        AnnotationIndex env = (AnnotationIndex)du.getAttachment(AnnotationIndex.class);
        if (env == null) {
            LOGGER.debug((Object)"Expecting AnnotationRepository class for scanning WAR for JAX-RS classes");
            return;
        }
        Set resources = null;
        Set providers = null;
        if (scanningData.isScanResources()) {
            resources = env.classIsAnnotatedWith(Path.class);
        }
        if (scanningData.isScanProviders()) {
            providers = env.classIsAnnotatedWith(Provider.class);
        }
        if ((resources == null || resources.isEmpty()) && (providers == null || providers.isEmpty())) {
            return;
        }
        if (resources != null) {
            for (Element e : resources) {
                if (e.getOwner().isInterface()) continue;
                scanningData.getResources().add(e.getOwnerClassName());
            }
        }
        if (providers != null) {
            for (Element e : providers) {
                if (e.getOwner().isInterface()) continue;
                scanningData.getProviders().add(e.getOwnerClassName());
            }
        }
        Set strings = env.classesImplementingInterfacesAnnotatedWith(Path.class.getName());
        scanningData.getResources().addAll(strings);
    }

    static {
        for (String clazz : ResteasyBootstrapClasses.BOOTSTRAP_CLASSES) {
            BOOT_CLASSES.add(clazz);
        }
    }
}

