/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.integration.SecurityActions;
import org.jboss.security.integration.SecurityConstantsBridge;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.plugins.JaasSecurityDomain;
import org.jboss.security.plugins.SecurityDomainContext;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class JNDIBasedSecurityManagement
implements ISecurityManagement {
    private static final long serialVersionUID = 1L;
    protected static Logger log = Logger.getLogger(JNDIBasedSecurityManagement.class);
    static ConcurrentHashMap<String, SecurityDomainContext> securityMgrMap = new ConcurrentHashMap();
    protected String BASE_CTX = "java:/jaas";
    protected String authenticationMgrClass = "org.jboss.security.plugins.JaasSecurityManager";
    protected String authorizationMgrClass = "org.jboss.security.plugins.JBossAuthorizationManager";
    protected String auditMgrClass = "org.jboss.security.plugins.audit.JBossAuditManager";
    protected String identityTrustMgrClass = "org.jboss.security.plugins.identitytrust.JBossIdentityTrustManager";
    protected String mappingMgrClass = "org.jboss.security.plugins.mapping.JBossMappingManager";
    protected CallbackHandler callBackHandler = new SecurityAssociationHandler();
    protected boolean enableIdentity = false;
    protected boolean enableAudit = true;
    private CachePolicy cachePolicy = null;
    private ConcurrentHashMap<String, AuthenticationManager> authMgrMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AuthorizationManager> authzMgrMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MappingManager> mappingMgrMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AuditManager> auditMgrMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, IdentityTrustManager> idmMgrMap = new ConcurrentHashMap();

    public AuditManager getAuditManager(String securityDomain) {
        AuditManager auditManager = null;
        try {
            if (this.enableAudit && (auditManager = this.auditMgrMap.get(securityDomain)) == null) {
                auditManager = (AuditManager)this.lookUpJNDI(securityDomain + "/auditMgr");
                this.auditMgrMap.put(securityDomain, auditManager);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting audit mgr", (Throwable)e);
        }
        return auditManager;
    }

    public AuthenticationManager getAuthenticationManager(String securityDomain) {
        AuthenticationManager am = null;
        try {
            am = this.authMgrMap.get(securityDomain);
            if (am == null) {
                am = (AuthenticationManager)this.lookUpJNDI(securityDomain + "/authenticationMgr");
                this.authMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting authentication mgr", (Throwable)e);
        }
        return am;
    }

    public AuthorizationManager getAuthorizationManager(String securityDomain) {
        AuthorizationManager am = null;
        try {
            am = this.authzMgrMap.get(securityDomain);
            if (am == null) {
                am = (AuthorizationManager)this.lookUpJNDI(securityDomain + "/authorizationMgr");
                this.authzMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting authorization mgr", (Throwable)e);
        }
        return am;
    }

    public IdentityTrustManager getIdentityTrustManager(String securityDomain) {
        IdentityTrustManager am = null;
        try {
            if (this.enableIdentity && (am = this.idmMgrMap.get(securityDomain)) == null) {
                am = (IdentityTrustManager)this.lookUpJNDI(securityDomain + "/identityTrustMgr");
                this.idmMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting IdentityTrustManager", (Throwable)e);
        }
        return am;
    }

    public MappingManager getMappingManager(String securityDomain) {
        MappingManager am = null;
        try {
            am = this.mappingMgrMap.get(securityDomain);
            if (am == null) {
                am = (MappingManager)this.lookUpJNDI(securityDomain + "/mappingMgr");
                this.mappingMgrMap.put(securityDomain, am);
            }
        }
        catch (Exception e) {
            log.trace((Object)"Exception in getting MappingManager", (Throwable)e);
        }
        return am;
    }

    public void setAuthenticationMgrClass(String authenticationMgrClass) {
        this.authenticationMgrClass = authenticationMgrClass;
    }

    public void setAuthorizationMgrClass(String authorizationMgrClass) {
        this.authorizationMgrClass = authorizationMgrClass;
    }

    public void setAuditMgrClass(String auditMgrClass) {
        this.auditMgrClass = auditMgrClass;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public void setEnableIdentity(boolean enableIdentity) {
        this.enableIdentity = enableIdentity;
    }

    public void setIdentityTrustMgrClass(String identityTrustMgrClass) {
        this.identityTrustMgrClass = identityTrustMgrClass;
    }

    public void setMappingMgrClass(String mappingMgrClass) {
        this.mappingMgrClass = mappingMgrClass;
    }

    public void setCallBackHandler(CallbackHandler callBackHandler) {
        this.callBackHandler = callBackHandler;
    }

    public void setBaseContext(String ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is null");
        }
        this.BASE_CTX = ctx;
    }

    public void setCachePolicy(CachePolicy cp) {
        this.cachePolicy = cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCacheTimeout(String securityDomain, int timeoutInSecs, int resInSecs) {
        SecurityDomainContext securityDomainCtx = securityMgrMap.get(securityDomain);
        if (securityDomainCtx == null) {
            try {
                String lookupStr = "java:/jaas/" + securityDomain;
                securityDomainCtx = (SecurityDomainContext)new InitialContext().lookup(lookupStr);
                securityMgrMap.put(securityDomain, securityDomainCtx);
            }
            catch (NamingException e) {
                log.trace((Object)("SetCacheTimeOut:Failed to look up SecurityDomainCtx:" + securityDomain));
            }
        }
        if (securityDomainCtx != null) {
            CachePolicy cache = securityDomainCtx.getAuthenticationCache();
            if (cache != null && cache instanceof TimedCachePolicy) {
                TimedCachePolicy tcp;
                TimedCachePolicy timedCachePolicy = tcp = (TimedCachePolicy)cache;
                synchronized (timedCachePolicy) {
                    tcp.setDefaultLifetime(timeoutInSecs);
                    tcp.setResolution(resInSecs);
                }
            } else {
                log.warn((Object)("Failed to find cache policy for securityDomain='" + securityDomain + "'"));
            }
        }
    }

    public static void setDefaultCacheTimeout(int defaultCacheTimeout) {
        SecurityConstantsBridge.defaultCacheTimeout = defaultCacheTimeout;
    }

    public static void setDefaultCacheResolution(int defaultCacheResolution) {
        SecurityConstantsBridge.defaultCacheResolution = defaultCacheResolution;
    }

    public SecurityDomainContext createSecurityDomainContext(String domain) throws Exception {
        AuthenticationManager am = this.createAuthenticationManager(domain);
        if (this.cachePolicy == null) {
            this.cachePolicy = this.createDefaultCachePolicy();
        }
        JNDIBasedSecurityManagement.setSecurityDomainCache(am, this.cachePolicy);
        if (SecurityConfiguration.isDeepCopySubjectMode()) {
            JNDIBasedSecurityManagement.setDeepCopySubjectMode(am);
        }
        SecurityDomainContext securityDomainContext = new SecurityDomainContext(am, this.cachePolicy);
        securityDomainContext.setAuthorizationManager(this.createAuthorizationManager(domain));
        securityDomainContext.setAuditMgr(this.createAuditManager(domain));
        securityDomainContext.setIdentityTrustMgr(this.createIdentityTrustManager(domain));
        securityDomainContext.setMappingMgr(this.createMappingManager(domain));
        return securityDomainContext;
    }

    public void registerJaasSecurityDomainInstance(String domain, JaasSecurityDomain jsd) throws Exception {
        SecurityDomainContext sdc = securityMgrMap.get(domain);
        if (sdc != null) {
            sdc.setAuthenticationManager((AuthenticationManager)jsd);
        } else {
            sdc = this.createSecurityDomainContext(domain);
            sdc.setAuthenticationManager((AuthenticationManager)jsd);
        }
        securityMgrMap.put(domain, sdc);
    }

    private Object lookUpJNDI(String ctxName) {
        try {
            InitialContext ctx = new InitialContext();
            return ctx.lookup(this.BASE_CTX + "/" + ctxName);
        }
        catch (Exception e) {
            log.trace((Object)("Look up of JNDI for " + ctxName + " failed with " + e.getLocalizedMessage()));
            return null;
        }
    }

    private AuthenticationManager createAuthenticationManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.authenticationMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class, CallbackHandler.class);
        return (AuthenticationManager)ctr.newInstance(securityDomain, this.callBackHandler);
    }

    private AuthorizationManager createAuthorizationManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.authorizationMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (AuthorizationManager)ctr.newInstance(securityDomain);
    }

    private AuditManager createAuditManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.auditMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (AuditManager)ctr.newInstance(securityDomain);
    }

    private MappingManager createMappingManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.mappingMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (MappingManager)ctr.newInstance(securityDomain);
    }

    private IdentityTrustManager createIdentityTrustManager(String securityDomain) throws Exception {
        Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(this.identityTrustMgrClass);
        Constructor<?> ctr = clazz.getConstructor(String.class);
        return (IdentityTrustManager)ctr.newInstance(securityDomain);
    }

    private static void setSecurityDomainCache(AuthenticationManager securityMgr, CachePolicy cachePolicy) {
        block2: {
            try {
                Class[] setCachePolicyTypes = new Class[]{CachePolicy.class};
                Method m = securityMgr.getClass().getMethod("setCachePolicy", setCachePolicyTypes);
                Object[] setCachePolicyArgs = new Object[]{cachePolicy};
                m.invoke((Object)securityMgr, setCachePolicyArgs);
                log.debug((Object)("setCachePolicy, c=" + setCachePolicyArgs[0]));
            }
            catch (Exception e2) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)("Optional setCachePolicy failed" + e2.getLocalizedMessage()));
            }
        }
    }

    private static void setDeepCopySubjectMode(AuthenticationManager securityMgr) {
        block2: {
            try {
                Class[] argsType = new Class[]{Boolean.class};
                Method m = securityMgr.getClass().getMethod("setDeepCopySubjectOption", argsType);
                Object[] deepCopyArgs = new Object[]{Boolean.TRUE};
                m.invoke((Object)securityMgr, deepCopyArgs);
                log.trace((Object)("setDeepCopySubjectOption, option=" + deepCopyArgs[0]));
            }
            catch (Exception e2) {
                if (!log.isTraceEnabled()) break block2;
                log.trace((Object)("Optional setDeepCopySubjectMode failed" + e2.getLocalizedMessage()));
            }
        }
    }

    private CachePolicy createDefaultCachePolicy() {
        TimedCachePolicy cachePolicy = new TimedCachePolicy(SecurityConstantsBridge.defaultCacheTimeout, true, SecurityConstantsBridge.defaultCacheResolution);
        cachePolicy.create();
        cachePolicy.start();
        return cachePolicy;
    }
}

