/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.web;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.authorization.AuthorizationException;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.resources.WebResource;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.integration.ejb.SecurityHelper;
import org.jboss.security.integration.web.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAuthorizationHelper
extends SecurityHelper {
    private boolean enableAudit = true;

    public WebAuthorizationHelper(SecurityContext sc, boolean enableAudit) {
        super(sc);
        this.enableAudit = enableAudit;
    }

    public boolean checkResourcePermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, Subject callerSubject, AuthorizationManager authzMgr, String canonicalRequestURI) {
        boolean isAuthorized;
        block4: {
            isAuthorized = false;
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setPolicyContextID(PolicyContext.getContextID());
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            webResource.setCallerSubject(callerSubject);
            webResource.setCanonicalRequestURI(canonicalRequestURI);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = authzMgr.getSubjectRoles(callerSubject, (CallbackHandler)sch);
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, callerSubject, callerRoles);
                isAuthorized = permit == 1;
                String string = level = permit == 1 ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, (Resource)webResource, null);
                }
            }
            catch (AuthorizationException e) {
                isAuthorized = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasResourcePermission check failed:" + e.getLocalizedMessage()));
                }
                if (!this.enableAudit) break block4;
                this.authorizationAudit("Error", (Resource)webResource, (Exception)((Object)e));
            }
        }
        return isAuthorized;
    }

    public boolean hasRole(String roleName, Principal principal, String servletName, Set<Principal> principalRoles, AuthorizationManager authzMgr) {
        boolean hasTheRole;
        block6: {
            hasTheRole = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("roleName", roleName);
            map.put("roleRefPermissionCheck", Boolean.TRUE);
            map.put("principal.roles", principalRoles);
            map.put("policyRegistration", authzMgr);
            WebResource webResource = new WebResource(Collections.unmodifiableMap(map));
            webResource.setPolicyContextID(PolicyContext.getContextID());
            webResource.setPrincipal(principal);
            webResource.setServletName(servletName);
            Subject subject = null;
            try {
                subject = SecurityActions.getActiveSubject();
            }
            catch (Exception e) {
                log.trace((Object)"Exception in getting subject:", (Throwable)e);
                subject = this.securityContext.getUtil().getSubject();
            }
            webResource.setCallerSubject(subject);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = authzMgr.getSubjectRoles(subject, (CallbackHandler)sch);
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, subject, callerRoles);
                hasTheRole = permit == 1;
                String string = level = hasTheRole ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, (Resource)webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasTheRole = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasRole check failed:" + e.getLocalizedMessage()));
                }
                if (!this.enableAudit) break block6;
                this.authorizationAudit("Error", (Resource)webResource, (Exception)((Object)e));
            }
        }
        return hasTheRole;
    }

    public boolean hasUserDataPermission(Map<String, Object> contextMap, ServletRequest request, ServletResponse response, AuthorizationManager authzMgr) {
        boolean hasPerm;
        block6: {
            hasPerm = false;
            contextMap.put("policyRegistration", authzMgr);
            WebResource webResource = new WebResource(Collections.unmodifiableMap(contextMap));
            webResource.setPolicyContextID(PolicyContext.getContextID());
            webResource.setServletRequest(request);
            webResource.setServletResponse(response);
            Subject subject = null;
            try {
                subject = SecurityActions.getActiveSubject();
            }
            catch (Exception e) {
                log.trace((Object)"Exception in getting subject:", (Throwable)e);
                subject = this.securityContext.getUtil().getSubject();
            }
            webResource.setCallerSubject(subject);
            SecurityContextCallbackHandler sch = new SecurityContextCallbackHandler(this.securityContext);
            RoleGroup callerRoles = authzMgr.getSubjectRoles(subject, (CallbackHandler)sch);
            try {
                String level;
                int permit = authzMgr.authorize((Resource)webResource, subject, callerRoles);
                hasPerm = permit == 1;
                String string = level = hasPerm ? "Success" : "Failure";
                if (this.enableAudit) {
                    this.authorizationAudit(level, (Resource)webResource, null);
                }
            }
            catch (AuthorizationException e) {
                hasPerm = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("hasRole check failed:" + e.getLocalizedMessage()));
                }
                if (!this.enableAudit) break block6;
                this.authorizationAudit("Error", (Resource)webResource, (Exception)((Object)e));
            }
        }
        return hasPerm;
    }
}

