/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.ejb.EJBContext;
import org.jboss.security.SecurityProxy;

public abstract class AbstractSecurityProxy
implements SecurityProxy {
    private HashMap methodMap;
    private Method setContextMethod;
    private Method setBeanMethod;
    protected Object delegate;
    protected boolean strict = false;

    AbstractSecurityProxy(Object delegate) {
        this.delegate = delegate;
        this.methodMap = new HashMap();
    }

    protected abstract void invokeHomeOnDelegate(Method var1, Object[] var2, Object var3) throws Exception;

    protected abstract void invokeOnDelegate(Method var1, Object[] var2, Object var3) throws Exception;

    public void init(Class beanHome, Class beanRemote, Object securityMgr) throws InstantiationException {
        this.init(beanHome, beanRemote, null, null, securityMgr);
    }

    public void init(Class beanHome, Class beanRemote, Class beanLocalHome, Class beanLocal, Object securityMgr) throws InstantiationException {
        Class[] parameterTypes;
        this.mapHomeMethods(beanHome);
        this.mapHomeMethods(beanLocalHome);
        this.mapRemoteMethods(beanRemote);
        this.mapRemoteMethods(beanLocal);
        try {
            parameterTypes = new Class[]{EJBContext.class};
            this.setContextMethod = this.delegate.getClass().getMethod("setEJBContext", parameterTypes);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            parameterTypes = new Class[]{Object.class};
            this.setBeanMethod = this.delegate.getClass().getMethod("setBean", parameterTypes);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            parameterTypes = new Class[]{};
            Object[] args = new Object[]{};
            Method isStrict = this.delegate.getClass().getMethod("isStrict", parameterTypes);
            Boolean flag = (Boolean)isStrict.invoke(this.delegate, args);
            this.strict = flag;
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    public void setEJBContext(EJBContext ctx) {
        if (this.setContextMethod != null) {
            Object[] args = new Object[]{ctx};
            try {
                this.setContextMethod.invoke(this.delegate, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void invokeHome(Method m, Object[] args) throws Exception {
        Method delegateMethod = (Method)this.methodMap.get(m);
        if (delegateMethod != null) {
            this.invokeHomeOnDelegate(delegateMethod, args, this.delegate);
        }
    }

    public void invoke(Method m, Object[] args, Object bean) throws Exception {
        Method delegateMethod = (Method)this.methodMap.get(m);
        if (delegateMethod != null) {
            if (this.setBeanMethod != null) {
                Object[] bargs = new Object[]{bean};
                try {
                    this.setBeanMethod.invoke(this.delegate, bargs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SecurityException("Failed to set bean on proxy" + e.getMessage());
                }
            }
            this.invokeOnDelegate(delegateMethod, args, this.delegate);
        }
    }

    protected void mapHomeMethods(Class beanHome) {
        if (beanHome == null) {
            return;
        }
        Class<?> delegateClass = this.delegate.getClass();
        Method[] methods = beanHome.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method hm = methods[m];
            Class<?>[] parameterTypes = hm.getParameterTypes();
            String name = hm.getName();
            name = "ejb" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            try {
                Method match = delegateClass.getMethod(name, parameterTypes);
                this.methodMap.put(hm, match);
                continue;
            }
            catch (NoSuchMethodException e) {
                name = hm.getName();
                try {
                    Method match = delegateClass.getMethod(name, parameterTypes);
                    this.methodMap.put(hm, match);
                    continue;
                }
                catch (NoSuchMethodException e2) {
                    if (!this.strict) continue;
                    String msg = "Missing home method:" + hm + " in delegate";
                    throw new SecurityException(msg);
                }
            }
        }
    }

    protected void mapRemoteMethods(Class beanRemote) {
        if (beanRemote == null) {
            return;
        }
        Class<?> delegateClass = this.delegate.getClass();
        Method[] methods = beanRemote.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Method rm = methods[m];
            Class<?>[] parameterTypes = rm.getParameterTypes();
            String name = rm.getName();
            try {
                Method match = delegateClass.getMethod(name, parameterTypes);
                this.methodMap.put(rm, match);
                continue;
            }
            catch (NoSuchMethodException e) {
                if (!this.strict) continue;
                String msg = "Missing method:" + rm + " in delegate";
                throw new SecurityException(msg);
            }
        }
    }
}

