/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.jboss.beans.metadata.api.annotations.FactoryMethod;
import org.jboss.logging.Logger;
import org.jboss.security.Util;
import org.jboss.security.plugins.SecurityKeyManager;
import org.jboss.security.ssl.JBossProvider;

public class JBossSSLConfiguration {
    private Provider provider;
    private String keyStoreType;
    private URL keyStoreURL;
    private char[] keyStorePass;
    private String keyStoreAlias;
    private String keyStoreProvider;
    private String keyStoreProviderArgument;
    private KeyStore keyStore;
    private String trustStoreType;
    private URL trustStoreURL;
    private char[] trustStorePass;
    private String trustStoreProvider;
    private String trustStoreProviderArgument;
    private KeyStore trustStore;
    private static JBossSSLConfiguration singleton;
    private static Logger log;

    private JBossSSLConfiguration() {
    }

    @FactoryMethod
    public static JBossSSLConfiguration getInstance() {
        if (singleton == null) {
            singleton = new JBossSSLConfiguration();
        }
        return singleton;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreURL() {
        String url = null;
        if (this.keyStoreURL != null) {
            url = this.keyStoreURL.toExternalForm();
        }
        return url;
    }

    public void setKeyStoreURL(String keyStoreURL) throws IOException {
        this.keyStoreURL = this.validateStoreURL(keyStoreURL);
    }

    public void setKeyStorePassword(String keyStorePassword) throws Exception {
        this.keyStorePass = Util.loadPassword(keyStorePassword);
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public void setKeyStoreAlias(String alias) {
        this.keyStoreAlias = alias;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public String getKeyStoreProviderArgument() {
        return this.keyStoreProviderArgument;
    }

    public void setKeyStoreProviderArgument(String keyStoreProviderArgument) {
        this.keyStoreProviderArgument = keyStoreProviderArgument;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStoreURL() {
        String url = null;
        if (this.trustStoreURL != null) {
            url = this.trustStoreURL.toExternalForm();
        }
        return url;
    }

    public void setTrustStoreURL(String trustStoreURL) throws IOException {
        this.trustStoreURL = this.validateStoreURL(trustStoreURL);
    }

    public void setTrustStorePassword(String trustStorePassword) throws Exception {
        this.trustStorePass = Util.loadPassword(trustStorePassword);
    }

    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public String getTrustStoreProviderArgument() {
        return this.trustStoreProviderArgument;
    }

    public void setTrustStoreProviderArgument(String trustStoreProviderArgument) {
        this.trustStoreProviderArgument = trustStoreProviderArgument;
    }

    public void start() throws Exception {
        InputStream is;
        Provider provider;
        Object[] ctorArgs;
        Constructor<?> ctor;
        Class[] ctorSig;
        Class<?> clazz;
        ClassLoader loader;
        this.provider = new JBossProvider();
        JBossSSLConfiguration.addProvider(this.provider);
        if (this.keyStorePass != null) {
            if (this.keyStoreType == null) {
                this.keyStoreType = KeyStore.getDefaultType();
            }
            if (this.keyStoreProvider != null) {
                if (this.keyStoreProviderArgument != null) {
                    loader = JBossSSLConfiguration.getContextClassLoader();
                    clazz = loader.loadClass(this.keyStoreProvider);
                    ctorSig = new Class[]{String.class};
                    ctor = clazz.getConstructor(ctorSig);
                    ctorArgs = new Object[]{this.keyStoreProviderArgument};
                    provider = (Provider)ctor.newInstance(ctorArgs);
                    this.keyStore = KeyStore.getInstance(this.keyStoreType, provider);
                } else {
                    this.keyStore = KeyStore.getInstance(this.keyStoreType, this.keyStoreProvider);
                }
            } else {
                this.keyStore = KeyStore.getInstance(this.keyStoreType);
            }
            is = null;
            if (!("PKCS11".equalsIgnoreCase(this.keyStoreType) && "PKCS11IMPLKS".equalsIgnoreCase(this.keyStoreType) || this.keyStoreURL == null)) {
                is = this.keyStoreURL.openStream();
            }
            this.keyStore.load(is, this.keyStorePass);
            if (this.keyStoreAlias != null && !this.keyStore.isKeyEntry(this.keyStoreAlias)) {
                throw new IOException("Cannot find key entry with alias " + this.keyStoreAlias + " in the keyStore");
            }
        }
        if (this.trustStorePass != null) {
            if (this.trustStoreType == null) {
                this.trustStoreType = KeyStore.getDefaultType();
            }
            if (this.trustStoreProvider != null) {
                if (this.trustStoreProviderArgument != null) {
                    loader = JBossSSLConfiguration.getContextClassLoader();
                    clazz = loader.loadClass(this.trustStoreProvider);
                    ctorSig = new Class[]{String.class};
                    ctor = clazz.getConstructor(ctorSig);
                    ctorArgs = new Object[]{this.trustStoreProviderArgument};
                    provider = (Provider)ctor.newInstance(ctorArgs);
                    this.trustStore = KeyStore.getInstance(this.trustStoreType, provider);
                } else {
                    this.trustStore = KeyStore.getInstance(this.trustStoreType, this.trustStoreProvider);
                }
            } else {
                this.trustStore = KeyStore.getInstance(this.trustStoreType);
            }
            is = null;
            if (!("PKCS11".equalsIgnoreCase(this.trustStoreType) && "PKCS11IMPLKS".equalsIgnoreCase(this.trustStoreType) || this.trustStoreURL == null)) {
                is = this.trustStoreURL.openStream();
            }
            this.trustStore.load(is, this.trustStorePass);
        }
    }

    public void stop() {
        if (this.provider != null) {
            JBossSSLConfiguration.removeProvider(this.provider);
        }
    }

    public void initializeKeyManagerFactory(KeyManagerFactory delegate) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (this.keyStore == null) {
            throw new KeyStoreException("Global keystore is not correctly initialized");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Using global keystore configuration");
        }
        delegate.init(this.keyStore, this.keyStorePass);
    }

    public KeyManager[] getKeyManagers(KeyManagerFactory delegate) {
        KeyManager[] keyManagers = delegate.getKeyManagers();
        if (this.keyStoreAlias != null) {
            for (int i = 0; i < keyManagers.length; ++i) {
                keyManagers[i] = new SecurityKeyManager((X509KeyManager)keyManagers[i], this.keyStoreAlias);
            }
        }
        return keyManagers;
    }

    public void initializeTrustManagerFactory(TrustManagerFactory delegate, KeyStore ks) throws KeyStoreException {
        if (this.trustStore == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Global truststore is not correctly initialized. Using local truststore configuration");
            }
            delegate.init(ks);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Using global truststore configuration");
            }
            delegate.init(this.trustStore);
        }
    }

    public void initializeTrustManagerFactory(TrustManagerFactory delegate, ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
        if (this.trustStore == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Global truststore is not correctly initialized. Using local truststore configuration");
            }
            delegate.init(spec);
        } else {
            CertPathTrustManagerParameters parameters = (CertPathTrustManagerParameters)spec;
            PKIXBuilderParameters oldParams = (PKIXBuilderParameters)parameters.getParameters();
            PKIXBuilderParameters xparams = null;
            try {
                xparams = new PKIXBuilderParameters(this.trustStore, (CertSelector)new X509CertSelector());
                xparams.setAnyPolicyInhibited(oldParams.isAnyPolicyInhibited());
                xparams.setCertPathCheckers(oldParams.getCertPathCheckers());
                xparams.setCertStores(oldParams.getCertStores());
                xparams.setDate(oldParams.getDate());
                xparams.setExplicitPolicyRequired(oldParams.isExplicitPolicyRequired());
                xparams.setInitialPolicies(oldParams.getInitialPolicies());
                xparams.setMaxPathLength(oldParams.getMaxPathLength());
                xparams.setPolicyMappingInhibited(oldParams.isPolicyMappingInhibited());
                xparams.setPolicyQualifiersRejected(oldParams.getPolicyQualifiersRejected());
                xparams.setRevocationEnabled(oldParams.isRevocationEnabled());
                xparams.setSigProvider(oldParams.getSigProvider());
            }
            catch (KeyStoreException ke) {
                log.error((Object)"Error initializing TrustManagerFactory", (Throwable)ke);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Using global truststore configuration");
            }
            CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(xparams);
            delegate.init(mfp);
        }
    }

    private URL validateStoreURL(String storeURL) throws IOException {
        File tst;
        URL url = null;
        try {
            url = new URL(storeURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null && (tst = new File(storeURL)).exists()) {
            url = tst.toURI().toURL();
        }
        if (url == null) {
            ClassLoader loader = JBossSSLConfiguration.getContextClassLoader();
            url = loader.getResource(storeURL);
        }
        if (url == null) {
            String msg = "Failed to find url=" + storeURL + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        return url;
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static Object addProvider(final Provider provider) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Security.insertProviderAt(provider, 1);
            }
        });
    }

    private static Object removeProvider(final Provider provider) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Security.removeProvider(provider.getName());
                return null;
            }
        });
    }

    static {
        log = Logger.getLogger(JBossSSLConfiguration.class);
    }
}

