/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.deployment.DeploymentException;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.DynamicLoginConfigMBean;
import org.jboss.security.auth.login.XMLLoginConfigMBean;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.PolicyConfig;
import org.jboss.system.ServiceMBeanSupport;

public class DynamicLoginConfig
extends ServiceMBeanSupport
implements DynamicLoginConfigMBean {
    private String authConf = "login-config.xml";
    private ObjectName loginConfigService;
    private ObjectName securityMgrService;
    private String[] configNames;
    private PolicyConfig config;

    public String getName() {
        return "Dynamic JAAS Login Config";
    }

    public PolicyConfig getPolicyConfig() {
        return this.config;
    }

    public void setPolicyConfig(PolicyConfig config) {
        this.config = config;
    }

    public ObjectName getLoginConfigService() {
        return this.loginConfigService;
    }

    public void setLoginConfigService(ObjectName serviceName) {
        this.loginConfigService = serviceName;
    }

    public ObjectName getSecurityManagerService() {
        return this.securityMgrService;
    }

    public void setSecurityManagerService(ObjectName serviceName) {
        this.securityMgrService = serviceName;
    }

    public String getAuthConfig() {
        return this.authConf;
    }

    public void setAuthConfig(String authConf) {
        this.authConf = authConf;
    }

    public void flushAuthenticationCaches() throws Exception {
        if (this.securityMgrService != null && this.server.isRegistered(this.securityMgrService)) {
            int count = this.configNames == null ? 0 : this.configNames.length;
            String[] sig = new String[]{String.class.getName()};
            for (int n = 0; n < count; ++n) {
                Object[] args = new Object[]{this.configNames[n]};
                this.server.invoke(this.securityMgrService, "flushAuthenticationCache", args, sig);
                this.log.debug((Object)("Flushed domain: " + this.configNames[n]));
            }
        }
    }

    protected void startService() throws Exception {
        if (this.config != null) {
            this.log.debug((Object)"Using embedded config");
            Set names = this.config.getConfigNames();
            Iterator iter = names.iterator();
            MBeanServer server = super.getServer();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                ApplicationPolicy aPolicy = this.config.get(name);
                if (aPolicy == null) {
                    throw new IllegalStateException("Application Policy is null for " + name);
                }
                AuthenticationInfo info = (AuthenticationInfo)aPolicy.getAuthenticationInfo();
                if (info == null) {
                    throw new IllegalStateException("Authentication Info is null for " + name);
                }
                AppConfigurationEntry[] entry = info.getAppConfigurationEntry();
                Object[] args = new Object[]{name, aPolicy};
                String[] sig = new String[]{String.class.getName(), aPolicy.getClass().getName()};
                server.invoke(this.loginConfigService, "addApplicationPolicy", args, sig);
            }
            this.configNames = new String[names.size()];
            names.toArray(this.configNames);
        } else {
            if (this.authConf == null || this.authConf.length() == 0) {
                throw new IllegalStateException("AuthConf is null. Please configure an appropriate config resource");
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL loginConfig = loader.getResource(this.authConf);
            if (loginConfig == null) {
                try {
                    loginConfig = new URL(this.authConf);
                }
                catch (Exception e) {
                    loginConfig = null;
                }
            }
            if (loginConfig != null) {
                this.validateAuthConfigURL(loginConfig);
                this.log.debug((Object)("Using JAAS AuthConfig: " + loginConfig.toExternalForm()));
                MBeanServer server = super.getServer();
                Object[] args = new Object[]{loginConfig};
                String[] sig = new String[]{URL.class.getName()};
                this.configNames = (String[])server.invoke(this.loginConfigService, "loadConfig", args, sig);
                int count = this.configNames == null ? 0 : this.configNames.length;
                for (int n = 0; n < count; ++n) {
                    this.log.debug((Object)("Loaded config: " + this.configNames[n]));
                }
            } else {
                throw new DeploymentException("Failed to find authConf as resource: " + this.authConf);
            }
        }
    }

    protected void stopService() throws Exception {
        MBeanServer server = super.getServer();
        this.flushAuthenticationCaches();
        if (this.configNames != null && this.configNames.length > 0) {
            Object[] args = new Object[]{this.configNames};
            String[] sig = new String[]{this.configNames.getClass().getName()};
            server.invoke(this.loginConfigService, "removeConfigs", args, sig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAuthConfigURL(URL url) throws Exception {
        String msg = "AuthConfig is defaulting to conf/login-config.xml. Please check your archive.";
        XMLLoginConfigMBean xmlConfig = null;
        try {
            xmlConfig = (XMLLoginConfigMBean)MBeanProxy.get(XMLLoginConfigMBean.class, (ObjectName)XMLLoginConfigMBean.OBJECT_NAME, (MBeanServer)this.server);
            if (xmlConfig.getConfigURL().sameFile(url)) {
                throw new IllegalStateException(msg);
            }
        }
        finally {
            xmlConfig = null;
        }
    }
}

