/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.deployment.security.JaccPolicyMBean;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.logging.Logger;

public class JaccPolicy
implements JaccPolicyMBean {
    private static Logger log = Logger.getLogger(JaccPolicy.class);
    private boolean trace = log.isTraceEnabled();
    private PolicyConfiguration parentPC = null;
    private String contextID = null;
    private Object metaData;
    private Boolean standaloneDeployment = Boolean.FALSE;

    public JaccPolicy(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Jacc Context Id passed is null");
        }
        this.contextID = id;
    }

    public JaccPolicy(String id, Object metaData, Boolean standaloneDeployment) {
        this(id);
        this.metaData = metaData;
        this.standaloneDeployment = standaloneDeployment;
    }

    public void create() {
        try {
            this.createPolicyConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.standaloneDeployment == Boolean.TRUE) {
            try {
                if (this.metaData != null) {
                    JaccPolicyUtil.createPermissions(this.parentPC, this.metaData);
                } else {
                    log.warn((Object)("Cannot create permissions with 'null' metaData for id=" + this.contextID));
                }
            }
            catch (PolicyContextException e) {
                throw new RuntimeException("Cannot create permissions:", e);
            }
        }
    }

    public void destroy() {
        this.parentPC = null;
    }

    public void start() {
        try {
            this.parentPC.commit();
        }
        catch (PolicyContextException e) {
            log.error((Object)"Cannot commit Parent Policy Configuration:", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.parentPC.delete();
        }
        catch (PolicyContextException e) {
            throw new RuntimeException(e);
        }
    }

    public void link(PolicyConfiguration pc) throws PolicyContextException {
        if (this.trace) {
            log.trace((Object)("Linking " + pc + " to parent pc=" + this.parentPC));
        }
        if (pc == null) {
            throw new IllegalArgumentException("pc is null");
        }
        try {
            this.createPolicyConfiguration();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.parentPC.linkConfiguration(pc);
    }

    private void createPolicyConfiguration() throws PolicyContextException, ClassNotFoundException {
        if (this.parentPC == null) {
            PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            this.parentPC = pcf.getPolicyConfiguration(this.contextID, true);
        }
    }
}

