/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.security.Permission;
import java.util.Iterator;
import java.util.Set;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MethodMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;

public class EJBPermissionMapping {
    public static void createPermissions(JBossEnterpriseBeanMetaData bean, PolicyConfiguration pc) throws PolicyContextException {
        JBossSessionBeanMetaData smd;
        SecurityRoleRefsMetaData refs;
        MethodsMetaData methods;
        ExcludeListMetaData excluded;
        MethodPermissionsMetaData perms = bean.getMethodPermissions();
        if (perms != null) {
            for (MethodPermissionMetaData perm : perms) {
                MethodsMetaData methods2 = perm.getMethods();
                if (methods2 == null) continue;
                for (org.jboss.metadata.ejb.spec.MethodMetaData mmd : methods2) {
                    MethodInterfaceType miType;
                    Object params = new String[]{};
                    params = mmd.getMethodParams() != null ? (String[])mmd.getMethodParams().toArray(params) : null;
                    String methodName = mmd.getMethodName();
                    if (methodName != null && methodName.equals("*")) {
                        methodName = null;
                    }
                    String iface = (miType = mmd.getMethodIntf()) != null ? miType.name() : null;
                    EJBMethodPermission p = new EJBMethodPermission(mmd.getEjbName(), methodName, iface, (String[])params);
                    if (perm.getUnchecked() != null) {
                        pc.addToUncheckedPolicy((Permission)p);
                        continue;
                    }
                    Set roles = perm.getRoles();
                    for (String role : roles) {
                        pc.addToRole(role, (Permission)p);
                    }
                }
            }
        }
        if ((excluded = bean.getExcludeList()) != null && (methods = excluded.getMethods()) != null) {
            for (org.jboss.metadata.ejb.spec.MethodMetaData mmd : methods) {
                MethodInterfaceType miType;
                Object params = new String[]{};
                params = mmd.getMethodParams() != null ? (String[])mmd.getMethodParams().toArray(params) : null;
                String methodName = mmd.getMethodName();
                if (methodName != null && methodName.equals("*")) {
                    methodName = null;
                }
                String iface = (miType = mmd.getMethodIntf()) != null ? miType.name() : null;
                EJBMethodPermission p = new EJBMethodPermission(mmd.getEjbName(), methodName, iface, (String[])params);
                pc.addToExcludedPolicy((Permission)p);
            }
        }
        if ((refs = bean.getSecurityRoleRefs()) != null) {
            for (SecurityRoleRefMetaData ref : refs) {
                EJBRoleRefPermission p = new EJBRoleRefPermission(bean.getEjbName(), ref.getRoleName());
                pc.addToRole(ref.getRoleLink(), (Permission)p);
            }
        }
        if (bean.isSession() && (smd = (JBossSessionBeanMetaData)bean).isStateful()) {
            EJBMethodPermission p = new EJBMethodPermission(bean.getEjbName(), "getEJBObject", "Home", null);
            pc.addToUncheckedPolicy((Permission)p);
        }
    }

    public static void createPermissions(BeanMetaData bean, PolicyConfiguration pc) throws PolicyContextException {
        SessionMetaData smd;
        EJBRoleRefPermission p;
        String[] params;
        MethodMetaData mmd;
        Iterator iter = bean.getPermissionMethods();
        while (iter.hasNext()) {
            String methodName;
            mmd = (MethodMetaData)iter.next();
            params = null;
            if (mmd.isParamGiven()) {
                params = mmd.getMethodParams();
            }
            if ((methodName = mmd.getMethodName()) != null && methodName.equals("*")) {
                methodName = null;
            }
            EJBMethodPermission p2 = new EJBMethodPermission(mmd.getEjbName(), methodName, mmd.getInterfaceType(), params);
            if (mmd.isUnchecked()) {
                pc.addToUncheckedPolicy((Permission)p2);
                continue;
            }
            Set roles = mmd.getRoles();
            for (String role : roles) {
                pc.addToRole(role, (Permission)p2);
            }
        }
        iter = bean.getExcludedMethods();
        while (iter.hasNext()) {
            mmd = (MethodMetaData)iter.next();
            params = null;
            if (mmd.isParamGiven()) {
                params = mmd.getMethodParams();
            }
            EJBMethodPermission p3 = new EJBMethodPermission(mmd.getEjbName(), mmd.getMethodName(), mmd.getInterfaceType(), params);
            pc.addToExcludedPolicy((Permission)p3);
        }
        iter = bean.getSecurityRoleReferences();
        while (iter.hasNext()) {
            org.jboss.metadata.SecurityRoleRefMetaData srrmd = (org.jboss.metadata.SecurityRoleRefMetaData)iter.next();
            p = new EJBRoleRefPermission(bean.getEjbName(), srrmd.getName());
            pc.addToRole(srrmd.getLink(), (Permission)p);
        }
        if (bean instanceof SessionMetaData && (smd = (SessionMetaData)bean).isStateful()) {
            p = new EJBMethodPermission(bean.getEjbName(), "getEJBObject", "Home", null);
            pc.addToUncheckedPolicy((Permission)p);
        }
    }
}

