/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.lock;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Stack;
import javax.ejb.EJBException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.ejb.plugins.lock.BeanLockSupport;
import org.jboss.invocation.Invocation;

public class SimpleReadWriteEJBLock
extends BeanLockSupport {
    int writersWaiting = 0;
    Transaction promotingReader = null;
    Transaction writer = null;
    HashSet readers = new HashSet();
    Object methodLock = new Object();
    boolean trace = log.isTraceEnabled();
    private static Stack kRecycledRelievers = new Stack();

    private void trace(Transaction tx, String message) {
        this.trace(tx, message, null);
    }

    private void trace(Transaction tx, String message, Method method) {
        if (method != null) {
            log.trace((Object)("LOCK(" + this.id + "):" + message + " : " + tx + " - " + method.getDeclaringClass().getName() + "." + method.getName()));
        } else {
            log.trace((Object)("LOCK(" + this.id + "):" + message + " : " + tx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Invocation mi) {
        boolean reading = mi.getMethod() == null ? false : this.container.getBeanMetaData().isMethodReadOnly(mi.getMethod().getName());
        Transaction miTx = mi.getTransaction();
        this.sync();
        try {
            if (reading) {
                if (this.trace) {
                    this.trace(miTx, "READ  (RQ)", mi.getMethod());
                }
                this.getReadLock(miTx);
                if (this.trace) {
                    this.trace(miTx, "READ  (GT)", mi.getMethod());
                }
            } else {
                if (this.trace) {
                    this.trace(miTx, "WRITE (RQ)", mi.getMethod());
                }
                this.getWriteLock(miTx);
                if (this.trace) {
                    this.trace(miTx, "WRITE (GT)", mi.getMethod());
                }
            }
        }
        finally {
            this.releaseSync();
        }
    }

    private void getReadLock(Transaction tx) {
        boolean done = false;
        while (!done) {
            if (tx == null) {
                done = this.writer == null;
            } else if (this.readers.contains(tx)) {
                done = true;
            } else if (this.writer == null && this.promotingReader == null && this.writersWaiting == 0) {
                try {
                    ReadLockReliever reliever = SimpleReadWriteEJBLock.getReliever();
                    reliever.setup(this, tx);
                    tx.registerSynchronization((Synchronization)reliever);
                }
                catch (Exception e) {
                    throw new EJBException(e);
                }
                this.readers.add(tx);
                done = true;
            } else if (this.writer != null && this.writer.equals(tx)) {
                done = true;
            }
            if (done) continue;
            if (this.trace) {
                this.trace(tx, "READ (WT) writer:" + this.writer + " writers waiting: " + this.writersWaiting + " reader count: " + this.readers.size());
            }
            this.waitAWhile(tx);
        }
    }

    private void getWriteLock(Transaction tx) {
        boolean done = false;
        if (tx == null) {
            throw new EJBException("Write lock requested without transaction.");
        }
        boolean isReader = this.readers.contains(tx);
        ++this.writersWaiting;
        while (!done) {
            if (this.writer == null && (this.readers.isEmpty() || this.readers.size() == 1 && isReader)) {
                --this.writersWaiting;
                this.promotingReader = null;
                this.writer = tx;
                done = true;
                continue;
            }
            if (this.writer != null && this.writer.equals(tx)) {
                --this.writersWaiting;
                done = true;
                continue;
            }
            if (isReader) {
                if (this.promotingReader != null && !this.promotingReader.equals(tx)) {
                    --this.writersWaiting;
                    throw new EJBException("Contention on read lock promotion for bean.  Exception in second transaction");
                }
                this.promotingReader = tx;
            }
            if (this.trace) {
                this.trace(tx, "WRITE (WT) writer:" + this.writer + " writers waiting: " + this.writersWaiting + " reader count: " + this.readers.size());
            }
            this.waitAWhile(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAWhile(Transaction tx) {
        this.releaseSync();
        try {
            HashSet hashSet = this.readers;
            synchronized (hashSet) {
                try {
                    this.readers.wait(this.txTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.checkTransaction(tx);
            }
        }
        finally {
            this.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaiters() {
        HashSet hashSet = this.readers;
        synchronized (hashSet) {
            this.readers.notifyAll();
        }
    }

    private void releaseReadLock(Transaction transaction) {
        if (this.trace) {
            this.trace(transaction, "READ  (UL)");
        }
        if (!this.readers.remove(transaction)) {
            throw new IllegalStateException("ReadWriteEJBLock: Read lock released when it wasn't taken");
        }
        this.notifyWaiters();
    }

    private void releaseWriteLock(Transaction transaction) {
        if (this.trace) {
            this.trace(transaction, "WRITE (UL)");
        }
        if (this.synched == null) {
            throw new IllegalStateException("ReadWriteEJBLock: Do not call nextTransaction while not synched!");
        }
        if (this.writer != null && !this.writer.equals(transaction)) {
            throw new IllegalStateException("ReadWriteEJBLock: can't unlock a write lock with a different transaction");
        }
        this.writer = null;
        this.notifyWaiters();
    }

    public void endTransaction(Transaction transaction) {
        this.releaseWriteLock(transaction);
    }

    public void wontSynchronize(Transaction transaction) {
        this.releaseWriteLock(transaction);
    }

    public void endInvocation(Invocation mi) {
    }

    static synchronized ReadLockReliever getReliever() {
        ReadLockReliever reliever = !kRecycledRelievers.empty() ? (ReadLockReliever)kRecycledRelievers.pop() : new ReadLockReliever();
        return reliever;
    }

    private void checkTransaction(Transaction tx) {
        try {
            if (tx != null && tx.getStatus() == 1) {
                throw new EJBException("Transaction marked for rollback - probably a timeout.");
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    private static class ReadLockReliever
    implements Synchronization {
        SimpleReadWriteEJBLock lock;
        Transaction transaction;

        private ReadLockReliever() {
        }

        protected void finalize() {
            this.recycle();
        }

        protected void recycle() {
            this.lock = null;
            this.transaction = null;
            kRecycledRelievers.push(this);
        }

        void setup(SimpleReadWriteEJBLock lock, Transaction transaction) {
            this.lock = lock;
            this.transaction = transaction;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            this.lock.sync();
            try {
                this.lock.releaseReadLock(this.transaction);
            }
            finally {
                this.lock.releaseSync();
            }
            this.recycle();
        }
    }
}

