/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.security;

import java.lang.reflect.Method;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.security.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityIdentity;

public class PreSecurityInterceptor
extends AbstractInterceptor {
    private String securityDomain = null;
    private String timedObjectMethod = null;

    public void setContainer(Container container) {
        AuthenticationManager am;
        super.setContainer(container);
        if (container != null && (am = container.getSecurityManager()) != null) {
            this.securityDomain = am.getSecurityDomain();
        }
        try {
            this.timedObjectMethod = TimedObject.class.getMethod("ejbTimeout", Timer.class).getName();
        }
        catch (Exception e) {
            this.log.trace((Object)"Exception in creating TimedObject method:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        boolean isEjbTimeOutMethod;
        if (this.securityDomain == null) {
            return this.getNext().invoke(mi);
        }
        SecurityIdentity si = null;
        Method m = mi.getMethod();
        boolean bl = isEjbTimeOutMethod = m != null && m.getName().equals(this.timedObjectMethod);
        if (mi.isLocal() && !isEjbTimeOutMethod) {
            SecurityContext sc = SecurityActions.getSecurityContext();
            if (sc != null) {
                si = sc.getUtil().getSecurityIdentity();
            }
            mi.setSecurityContext(sc);
        } else {
            this.establishSecurityContext(mi);
        }
        try {
            Object returnValue;
            SecurityActions.pushCallerRunAsIdentity(SecurityActions.getSecurityContext().getOutgoingRunAs());
            Object object = returnValue = this.getNext().invoke(mi);
            return object;
        }
        finally {
            SecurityActions.popCallerRunAsIdentity();
            if (mi.isLocal() && si != null) {
                SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        boolean isEjbTimeOutMethod;
        if (this.securityDomain == null) {
            return this.getNext().invokeHome(mi);
        }
        SecurityIdentity si = null;
        Method m = mi.getMethod();
        boolean bl = isEjbTimeOutMethod = m != null && m.getName().equals(this.timedObjectMethod);
        if (mi.isLocal() && !isEjbTimeOutMethod) {
            SecurityContext sc = SecurityActions.getSecurityContext();
            if (sc != null) {
                si = sc.getUtil().getSecurityIdentity();
            }
            mi.setSecurityContext(sc);
        } else {
            this.establishSecurityContext(mi);
        }
        try {
            Object returnValue;
            SecurityActions.pushCallerRunAsIdentity(SecurityActions.getSecurityContext().getOutgoingRunAs());
            Object object = returnValue = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            SecurityActions.popCallerRunAsIdentity();
            if (mi.isLocal() && si != null) {
                SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
            }
        }
    }

    private void establishSecurityContext(Invocation mi) throws Exception {
        SecurityContext sc = mi.getSecurityContext();
        SecurityContext newSC = SecurityActions.createAndSetSecurityContext(this.securityDomain, this.container.getSecurityContextClassName());
        if (sc != null) {
            SecurityActions.setSecurityIdentity(newSC, sc.getUtil().getSecurityIdentity());
        } else {
            mi.setSecurityContext(newSC);
        }
        newSC.setSecurityManagement(this.container.getSecurityManagement());
    }
}

